/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detail of the partition field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeDatasetPartitionField implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeDatasetPartitionField.Builder, DataLakeDatasetPartitionField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataLakeDatasetPartitionField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<DataLakeDatasetPartitionFieldTransform> TRANSFORM_FIELD = SdkField
            .<DataLakeDatasetPartitionFieldTransform> builder(MarshallingType.SDK_POJO).memberName("transform")
            .getter(getter(DataLakeDatasetPartitionField::transform)).setter(setter(Builder::transform))
            .constructor(DataLakeDatasetPartitionFieldTransform::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transform").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TRANSFORM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final DataLakeDatasetPartitionFieldTransform transform;

    private DataLakeDatasetPartitionField(BuilderImpl builder) {
        this.name = builder.name;
        this.transform = builder.transform;
    }

    /**
     * <p>
     * The name of the partition field.
     * </p>
     * 
     * @return The name of the partition field.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The transformation of the partition field. A transformation specifies how to partition on a given field. For
     * example, with timestamp you can specify that you'd like to partition fields by day, e.g. data record with value
     * 2025-01-03T00:00:00Z in partition field is in 2025-01-03 partition. Also noted that data record without any value
     * in optional partition field is in NULL partition.
     * </p>
     * 
     * @return The transformation of the partition field. A transformation specifies how to partition on a given field.
     *         For example, with timestamp you can specify that you'd like to partition fields by day, e.g. data record
     *         with value 2025-01-03T00:00:00Z in partition field is in 2025-01-03 partition. Also noted that data
     *         record without any value in optional partition field is in NULL partition.
     */
    public final DataLakeDatasetPartitionFieldTransform transform() {
        return transform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(transform());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeDatasetPartitionField)) {
            return false;
        }
        DataLakeDatasetPartitionField other = (DataLakeDatasetPartitionField) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(transform(), other.transform());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeDatasetPartitionField").add("Name", name()).add("Transform", transform()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "transform":
            return Optional.ofNullable(clazz.cast(transform()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("transform", TRANSFORM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeDatasetPartitionField, T> g) {
        return obj -> g.apply((DataLakeDatasetPartitionField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeDatasetPartitionField> {
        /**
         * <p>
         * The name of the partition field.
         * </p>
         * 
         * @param name
         *        The name of the partition field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The transformation of the partition field. A transformation specifies how to partition on a given field. For
         * example, with timestamp you can specify that you'd like to partition fields by day, e.g. data record with
         * value 2025-01-03T00:00:00Z in partition field is in 2025-01-03 partition. Also noted that data record without
         * any value in optional partition field is in NULL partition.
         * </p>
         * 
         * @param transform
         *        The transformation of the partition field. A transformation specifies how to partition on a given
         *        field. For example, with timestamp you can specify that you'd like to partition fields by day, e.g.
         *        data record with value 2025-01-03T00:00:00Z in partition field is in 2025-01-03 partition. Also noted
         *        that data record without any value in optional partition field is in NULL partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transform(DataLakeDatasetPartitionFieldTransform transform);

        /**
         * <p>
         * The transformation of the partition field. A transformation specifies how to partition on a given field. For
         * example, with timestamp you can specify that you'd like to partition fields by day, e.g. data record with
         * value 2025-01-03T00:00:00Z in partition field is in 2025-01-03 partition. Also noted that data record without
         * any value in optional partition field is in NULL partition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataLakeDatasetPartitionFieldTransform.Builder} avoiding the need to create one manually via
         * {@link DataLakeDatasetPartitionFieldTransform#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeDatasetPartitionFieldTransform.Builder#build()} is called
         * immediately and its result is passed to {@link #transform(DataLakeDatasetPartitionFieldTransform)}.
         * 
         * @param transform
         *        a consumer that will call methods on {@link DataLakeDatasetPartitionFieldTransform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transform(DataLakeDatasetPartitionFieldTransform)
         */
        default Builder transform(Consumer<DataLakeDatasetPartitionFieldTransform.Builder> transform) {
            return transform(DataLakeDatasetPartitionFieldTransform.builder().applyMutation(transform).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private DataLakeDatasetPartitionFieldTransform transform;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeDatasetPartitionField model) {
            name(model.name);
            transform(model.transform);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DataLakeDatasetPartitionFieldTransform.Builder getTransform() {
            return transform != null ? transform.toBuilder() : null;
        }

        public final void setTransform(DataLakeDatasetPartitionFieldTransform.BuilderImpl transform) {
            this.transform = transform != null ? transform.build() : null;
        }

        @Override
        public final Builder transform(DataLakeDatasetPartitionFieldTransform transform) {
            this.transform = transform;
            return this;
        }

        @Override
        public DataLakeDatasetPartitionField build() {
            return new DataLakeDatasetPartitionField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
