/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response parameters for GetDataIntegrationEvent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataIntegrationEventResponse extends SupplyChainResponse implements
        ToCopyableBuilder<GetDataIntegrationEventResponse.Builder, GetDataIntegrationEventResponse> {
    private static final SdkField<DataIntegrationEvent> EVENT_FIELD = SdkField
            .<DataIntegrationEvent> builder(MarshallingType.SDK_POJO).memberName("event")
            .getter(getter(GetDataIntegrationEventResponse::event)).setter(setter(Builder::event))
            .constructor(DataIntegrationEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DataIntegrationEvent event;

    private GetDataIntegrationEventResponse(BuilderImpl builder) {
        super(builder);
        this.event = builder.event;
    }

    /**
     * <p>
     * The details of the DataIntegrationEvent returned.
     * </p>
     * 
     * @return The details of the DataIntegrationEvent returned.
     */
    public final DataIntegrationEvent event() {
        return event;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(event());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataIntegrationEventResponse)) {
            return false;
        }
        GetDataIntegrationEventResponse other = (GetDataIntegrationEventResponse) obj;
        return Objects.equals(event(), other.event());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataIntegrationEventResponse").add("Event", event()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "event":
            return Optional.ofNullable(clazz.cast(event()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("event", EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataIntegrationEventResponse, T> g) {
        return obj -> g.apply((GetDataIntegrationEventResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SupplyChainResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataIntegrationEventResponse> {
        /**
         * <p>
         * The details of the DataIntegrationEvent returned.
         * </p>
         * 
         * @param event
         *        The details of the DataIntegrationEvent returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(DataIntegrationEvent event);

        /**
         * <p>
         * The details of the DataIntegrationEvent returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataIntegrationEvent.Builder} avoiding
         * the need to create one manually via {@link DataIntegrationEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationEvent.Builder#build()} is called immediately and
         * its result is passed to {@link #event(DataIntegrationEvent)}.
         * 
         * @param event
         *        a consumer that will call methods on {@link DataIntegrationEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #event(DataIntegrationEvent)
         */
        default Builder event(Consumer<DataIntegrationEvent.Builder> event) {
            return event(DataIntegrationEvent.builder().applyMutation(event).build());
        }
    }

    static final class BuilderImpl extends SupplyChainResponse.BuilderImpl implements Builder {
        private DataIntegrationEvent event;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataIntegrationEventResponse model) {
            super(model);
            event(model.event);
        }

        public final DataIntegrationEvent.Builder getEvent() {
            return event != null ? event.toBuilder() : null;
        }

        public final void setEvent(DataIntegrationEvent.BuilderImpl event) {
            this.event = event != null ? event.build() : null;
        }

        @Override
        public final Builder event(DataIntegrationEvent event) {
            this.event = event;
            return this;
        }

        @Override
        public GetDataIntegrationEventResponse build() {
            return new GetDataIntegrationEventResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
