/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobRequest;
import software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobResponse;
import software.amazon.awssdk.services.supplychain.model.CreateDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.CreateDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.CreateDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.CreateDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.CreateDataLakeNamespaceRequest;
import software.amazon.awssdk.services.supplychain.model.CreateDataLakeNamespaceResponse;
import software.amazon.awssdk.services.supplychain.model.CreateInstanceRequest;
import software.amazon.awssdk.services.supplychain.model.CreateInstanceResponse;
import software.amazon.awssdk.services.supplychain.model.DeleteDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.DeleteDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.DeleteDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.DeleteDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.DeleteDataLakeNamespaceRequest;
import software.amazon.awssdk.services.supplychain.model.DeleteDataLakeNamespaceResponse;
import software.amazon.awssdk.services.supplychain.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.supplychain.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobRequest;
import software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationEventRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationEventResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowExecutionRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowExecutionResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.GetDataLakeNamespaceRequest;
import software.amazon.awssdk.services.supplychain.model.GetDataLakeNamespaceResponse;
import software.amazon.awssdk.services.supplychain.model.GetInstanceRequest;
import software.amazon.awssdk.services.supplychain.model.GetInstanceResponse;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsResponse;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsResponse;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesResponse;
import software.amazon.awssdk.services.supplychain.model.ListInstancesRequest;
import software.amazon.awssdk.services.supplychain.model.ListInstancesResponse;
import software.amazon.awssdk.services.supplychain.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.supplychain.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.supplychain.model.SendDataIntegrationEventRequest;
import software.amazon.awssdk.services.supplychain.model.SendDataIntegrationEventResponse;
import software.amazon.awssdk.services.supplychain.model.TagResourceRequest;
import software.amazon.awssdk.services.supplychain.model.TagResourceResponse;
import software.amazon.awssdk.services.supplychain.model.UntagResourceRequest;
import software.amazon.awssdk.services.supplychain.model.UntagResourceResponse;
import software.amazon.awssdk.services.supplychain.model.UpdateDataIntegrationFlowRequest;
import software.amazon.awssdk.services.supplychain.model.UpdateDataIntegrationFlowResponse;
import software.amazon.awssdk.services.supplychain.model.UpdateDataLakeDatasetRequest;
import software.amazon.awssdk.services.supplychain.model.UpdateDataLakeDatasetResponse;
import software.amazon.awssdk.services.supplychain.model.UpdateDataLakeNamespaceRequest;
import software.amazon.awssdk.services.supplychain.model.UpdateDataLakeNamespaceResponse;
import software.amazon.awssdk.services.supplychain.model.UpdateInstanceRequest;
import software.amazon.awssdk.services.supplychain.model.UpdateInstanceResponse;
import software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsPublisher;
import software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsPublisher;
import software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsPublisher;
import software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsPublisher;
import software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesPublisher;
import software.amazon.awssdk.services.supplychain.paginators.ListInstancesPublisher;

/**
 * Service client for accessing AWS Supply Chain asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * AWS Supply Chain is a cloud-based application that works with your enterprise resource planning (ERP) and supply
 * chain management systems. Using AWS Supply Chain, you can connect and extract your inventory, supply, and demand
 * related data from existing ERP or supply chain systems into a single data model.
 * </p>
 * <p>
 * The AWS Supply Chain API supports configuration data import for Supply Planning.
 * </p>
 * <p>
 * All AWS Supply chain API operations are Amazon-authenticated and certificate-signed. They not only require the use of
 * the AWS SDK, but also allow for the exclusive use of AWS Identity and Access Management users and roles to help
 * facilitate access, trust, and permission policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SupplyChainAsyncClient extends AwsClient {
    String SERVICE_NAME = "scn";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "scn";

    /**
     * <p>
     * CreateBillOfMaterialsImportJob creates an import job for the Product Bill Of Materials (BOM) entity. For
     * information on the product_bom entity, see the AWS Supply Chain User Guide.
     * </p>
     * <p>
     * The CSV file must be located in an Amazon S3 location accessible to AWS Supply Chain. It is recommended to use
     * the same Amazon S3 bucket created during your AWS Supply Chain instance creation.
     * </p>
     *
     * @param createBillOfMaterialsImportJobRequest
     *        The request parameters for CreateBillOfMaterialsImportJob.
     * @return A Java Future containing the result of the CreateBillOfMaterialsImportJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.CreateBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBillOfMaterialsImportJobResponse> createBillOfMaterialsImportJob(
            CreateBillOfMaterialsImportJobRequest createBillOfMaterialsImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * CreateBillOfMaterialsImportJob creates an import job for the Product Bill Of Materials (BOM) entity. For
     * information on the product_bom entity, see the AWS Supply Chain User Guide.
     * </p>
     * <p>
     * The CSV file must be located in an Amazon S3 location accessible to AWS Supply Chain. It is recommended to use
     * the same Amazon S3 bucket created during your AWS Supply Chain instance creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillOfMaterialsImportJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreateBillOfMaterialsImportJobRequest#builder()}
     * </p>
     *
     * @param createBillOfMaterialsImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateBillOfMaterialsImportJobRequest.Builder} to
     *        create a request. The request parameters for CreateBillOfMaterialsImportJob.
     * @return A Java Future containing the result of the CreateBillOfMaterialsImportJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.CreateBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBillOfMaterialsImportJobResponse> createBillOfMaterialsImportJob(
            Consumer<CreateBillOfMaterialsImportJobRequest.Builder> createBillOfMaterialsImportJobRequest) {
        return createBillOfMaterialsImportJob(CreateBillOfMaterialsImportJobRequest.builder()
                .applyMutation(createBillOfMaterialsImportJobRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically create a data pipeline to ingest data from source systems such as Amazon S3
     * buckets, to a predefined Amazon Web Services Supply Chain dataset (product, inbound_order) or a temporary dataset
     * along with the data transformation query provided with the API.
     * </p>
     *
     * @param createDataIntegrationFlowRequest
     *        The request parameters for CreateDataIntegrationFlow.
     * @return A Java Future containing the result of the CreateDataIntegrationFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.CreateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataIntegrationFlowResponse> createDataIntegrationFlow(
            CreateDataIntegrationFlowRequest createDataIntegrationFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically create a data pipeline to ingest data from source systems such as Amazon S3
     * buckets, to a predefined Amazon Web Services Supply Chain dataset (product, inbound_order) or a temporary dataset
     * along with the data transformation query provided with the API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataIntegrationFlowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param createDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateDataIntegrationFlowRequest.Builder} to
     *        create a request. The request parameters for CreateDataIntegrationFlow.
     * @return A Java Future containing the result of the CreateDataIntegrationFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.CreateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataIntegrationFlowResponse> createDataIntegrationFlow(
            Consumer<CreateDataIntegrationFlowRequest.Builder> createDataIntegrationFlowRequest) {
        return createDataIntegrationFlow(CreateDataIntegrationFlowRequest.builder()
                .applyMutation(createDataIntegrationFlowRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain data lake dataset. Developers can
     * create the datasets using their pre-defined or custom schema for a given instance ID, namespace, and dataset
     * name.
     * </p>
     *
     * @param createDataLakeDatasetRequest
     *        The request parameters for CreateDataLakeDataset.
     * @return A Java Future containing the result of the CreateDataLakeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.CreateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataLakeDatasetResponse> createDataLakeDataset(
            CreateDataLakeDatasetRequest createDataLakeDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain data lake dataset. Developers can
     * create the datasets using their pre-defined or custom schema for a given instance ID, namespace, and dataset
     * name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param createDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters for CreateDataLakeDataset.
     * @return A Java Future containing the result of the CreateDataLakeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.CreateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataLakeDatasetResponse> createDataLakeDataset(
            Consumer<CreateDataLakeDatasetRequest.Builder> createDataLakeDatasetRequest) {
        return createDataLakeDataset(CreateDataLakeDatasetRequest.builder().applyMutation(createDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain data lake namespace. Developers can
     * create the namespaces for a given instance ID.
     * </p>
     *
     * @param createDataLakeNamespaceRequest
     *        The request parameters for CreateDataLakeNamespace.
     * @return A Java Future containing the result of the CreateDataLakeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.CreateDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataLakeNamespaceResponse> createDataLakeNamespace(
            CreateDataLakeNamespaceRequest createDataLakeNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain data lake namespace. Developers can
     * create the namespaces for a given instance ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataLakeNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataLakeNamespaceRequest#builder()}
     * </p>
     *
     * @param createDataLakeNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateDataLakeNamespaceRequest.Builder} to create
     *        a request. The request parameters for CreateDataLakeNamespace.
     * @return A Java Future containing the result of the CreateDataLakeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.CreateDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataLakeNamespaceResponse> createDataLakeNamespace(
            Consumer<CreateDataLakeNamespaceRequest.Builder> createDataLakeNamespaceRequest) {
        return createDataLakeNamespace(CreateDataLakeNamespaceRequest.builder().applyMutation(createDataLakeNamespaceRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain instance by applying KMS keys and
     * relevant information associated with the API without using the Amazon Web Services console.
     * </p>
     * <p>
     * This is an asynchronous operation. Upon receiving a CreateInstance request, Amazon Web Services Supply Chain
     * immediately returns the instance resource, instance ID, and the initializing state while simultaneously creating
     * all required Amazon Web Services resources for an instance creation. You can use GetInstance to check the status
     * of the instance. If the instance results in an unhealthy state, you need to check the error message, delete the
     * current instance, and recreate a new one based on the mitigation from the error message.
     * </p>
     *
     * @param createInstanceRequest
     *        The request parameters for CreateInstance.
     * @return A Java Future containing the result of the CreateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInstanceResponse> createInstance(CreateInstanceRequest createInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically create an Amazon Web Services Supply Chain instance by applying KMS keys and
     * relevant information associated with the API without using the Amazon Web Services console.
     * </p>
     * <p>
     * This is an asynchronous operation. Upon receiving a CreateInstance request, Amazon Web Services Supply Chain
     * immediately returns the instance resource, instance ID, and the initializing state while simultaneously creating
     * all required Amazon Web Services resources for an instance creation. You can use GetInstance to check the status
     * of the instance. If the instance results in an unhealthy state, you need to check the error message, delete the
     * current instance, and recreate a new one based on the mitigation from the error message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInstanceRequest#builder()}
     * </p>
     *
     * @param createInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.CreateInstanceRequest.Builder} to create a
     *        request. The request parameters for CreateInstance.
     * @return A Java Future containing the result of the CreateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInstanceResponse> createInstance(Consumer<CreateInstanceRequest.Builder> createInstanceRequest) {
        return createInstance(CreateInstanceRequest.builder().applyMutation(createInstanceRequest).build());
    }

    /**
     * <p>
     * Enable you to programmatically delete an existing data pipeline for the provided Amazon Web Services Supply Chain
     * instance and DataIntegrationFlow name.
     * </p>
     *
     * @param deleteDataIntegrationFlowRequest
     *        The request parameters for DeleteDataIntegrationFlow.
     * @return A Java Future containing the result of the DeleteDataIntegrationFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.DeleteDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataIntegrationFlowResponse> deleteDataIntegrationFlow(
            DeleteDataIntegrationFlowRequest deleteDataIntegrationFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable you to programmatically delete an existing data pipeline for the provided Amazon Web Services Supply Chain
     * instance and DataIntegrationFlow name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataIntegrationFlowRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param deleteDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.DeleteDataIntegrationFlowRequest.Builder} to
     *        create a request. The request parameters for DeleteDataIntegrationFlow.
     * @return A Java Future containing the result of the DeleteDataIntegrationFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.DeleteDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataIntegrationFlowResponse> deleteDataIntegrationFlow(
            Consumer<DeleteDataIntegrationFlowRequest.Builder> deleteDataIntegrationFlowRequest) {
        return deleteDataIntegrationFlow(DeleteDataIntegrationFlowRequest.builder()
                .applyMutation(deleteDataIntegrationFlowRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain data lake dataset. Developers can
     * delete the existing datasets for a given instance ID, namespace, and instance name.
     * </p>
     *
     * @param deleteDataLakeDatasetRequest
     *        The request parameters of DeleteDataLakeDataset.
     * @return A Java Future containing the result of the DeleteDataLakeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.DeleteDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataLakeDatasetResponse> deleteDataLakeDataset(
            DeleteDataLakeDatasetRequest deleteDataLakeDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain data lake dataset. Developers can
     * delete the existing datasets for a given instance ID, namespace, and instance name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.DeleteDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters of DeleteDataLakeDataset.
     * @return A Java Future containing the result of the DeleteDataLakeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.DeleteDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataLakeDatasetResponse> deleteDataLakeDataset(
            Consumer<DeleteDataLakeDatasetRequest.Builder> deleteDataLakeDatasetRequest) {
        return deleteDataLakeDataset(DeleteDataLakeDatasetRequest.builder().applyMutation(deleteDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain data lake namespace and its underling
     * datasets. Developers can delete the existing namespaces for a given instance ID and namespace name.
     * </p>
     *
     * @param deleteDataLakeNamespaceRequest
     *        The request parameters of DeleteDataLakeNamespace.
     * @return A Java Future containing the result of the DeleteDataLakeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.DeleteDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataLakeNamespaceResponse> deleteDataLakeNamespace(
            DeleteDataLakeNamespaceRequest deleteDataLakeNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain data lake namespace and its underling
     * datasets. Developers can delete the existing namespaces for a given instance ID and namespace name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataLakeNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDataLakeNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteDataLakeNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.DeleteDataLakeNamespaceRequest.Builder} to create
     *        a request. The request parameters of DeleteDataLakeNamespace.
     * @return A Java Future containing the result of the DeleteDataLakeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.DeleteDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataLakeNamespaceResponse> deleteDataLakeNamespace(
            Consumer<DeleteDataLakeNamespaceRequest.Builder> deleteDataLakeNamespaceRequest) {
        return deleteDataLakeNamespace(DeleteDataLakeNamespaceRequest.builder().applyMutation(deleteDataLakeNamespaceRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain instance by deleting the KMS keys and
     * relevant information associated with the API without using the Amazon Web Services console.
     * </p>
     * <p>
     * This is an asynchronous operation. Upon receiving a DeleteInstance request, Amazon Web Services Supply Chain
     * immediately returns a response with the instance resource, delete state while cleaning up all Amazon Web Services
     * resources created during the instance creation process. You can use the GetInstance action to check the instance
     * status.
     * </p>
     *
     * @param deleteInstanceRequest
     *        The request parameters for DeleteInstance.
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically delete an Amazon Web Services Supply Chain instance by deleting the KMS keys and
     * relevant information associated with the API without using the Amazon Web Services console.
     * </p>
     * <p>
     * This is an asynchronous operation. Upon receiving a DeleteInstance request, Amazon Web Services Supply Chain
     * immediately returns a response with the instance resource, delete state while cleaning up all Amazon Web Services
     * resources created during the instance creation process. You can use the GetInstance action to check the instance
     * status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInstanceRequest#builder()}
     * </p>
     *
     * @param deleteInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.DeleteInstanceRequest.Builder} to create a
     *        request. The request parameters for DeleteInstance.
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceResponse> deleteInstance(Consumer<DeleteInstanceRequest.Builder> deleteInstanceRequest) {
        return deleteInstance(DeleteInstanceRequest.builder().applyMutation(deleteInstanceRequest).build());
    }

    /**
     * <p>
     * Get status and details of a BillOfMaterialsImportJob.
     * </p>
     *
     * @param getBillOfMaterialsImportJobRequest
     *        The request parameters for GetBillOfMaterialsImportJob.
     * @return A Java Future containing the result of the GetBillOfMaterialsImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBillOfMaterialsImportJobResponse> getBillOfMaterialsImportJob(
            GetBillOfMaterialsImportJobRequest getBillOfMaterialsImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get status and details of a BillOfMaterialsImportJob.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBillOfMaterialsImportJobRequest.Builder}
     * avoiding the need to create one manually via {@link GetBillOfMaterialsImportJobRequest#builder()}
     * </p>
     *
     * @param getBillOfMaterialsImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetBillOfMaterialsImportJobRequest.Builder} to
     *        create a request. The request parameters for GetBillOfMaterialsImportJob.
     * @return A Java Future containing the result of the GetBillOfMaterialsImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetBillOfMaterialsImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetBillOfMaterialsImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBillOfMaterialsImportJobResponse> getBillOfMaterialsImportJob(
            Consumer<GetBillOfMaterialsImportJobRequest.Builder> getBillOfMaterialsImportJobRequest) {
        return getBillOfMaterialsImportJob(GetBillOfMaterialsImportJobRequest.builder()
                .applyMutation(getBillOfMaterialsImportJobRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain Data Integration Event. Developers can
     * view the eventType, eventGroupId, eventTimestamp, datasetTarget, datasetLoadExecution.
     * </p>
     *
     * @param getDataIntegrationEventRequest
     *        The request parameters for GetDataIntegrationEvent.
     * @return A Java Future containing the result of the GetDataIntegrationEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetDataIntegrationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataIntegrationEventResponse> getDataIntegrationEvent(
            GetDataIntegrationEventRequest getDataIntegrationEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain Data Integration Event. Developers can
     * view the eventType, eventGroupId, eventTimestamp, datasetTarget, datasetLoadExecution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataIntegrationEventRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataIntegrationEventRequest#builder()}
     * </p>
     *
     * @param getDataIntegrationEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataIntegrationEventRequest.Builder} to create
     *        a request. The request parameters for GetDataIntegrationEvent.
     * @return A Java Future containing the result of the GetDataIntegrationEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetDataIntegrationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataIntegrationEventResponse> getDataIntegrationEvent(
            Consumer<GetDataIntegrationEventRequest.Builder> getDataIntegrationEventRequest) {
        return getDataIntegrationEvent(GetDataIntegrationEventRequest.builder().applyMutation(getDataIntegrationEventRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to programmatically view a specific data pipeline for the provided Amazon Web Services Supply Chain
     * instance and DataIntegrationFlow name.
     * </p>
     *
     * @param getDataIntegrationFlowRequest
     *        The request parameters for GetDataIntegrationFlow.
     * @return A Java Future containing the result of the GetDataIntegrationFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataIntegrationFlowResponse> getDataIntegrationFlow(
            GetDataIntegrationFlowRequest getDataIntegrationFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view a specific data pipeline for the provided Amazon Web Services Supply Chain
     * instance and DataIntegrationFlow name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataIntegrationFlowRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param getDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowRequest.Builder} to create
     *        a request. The request parameters for GetDataIntegrationFlow.
     * @return A Java Future containing the result of the GetDataIntegrationFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataIntegrationFlowResponse> getDataIntegrationFlow(
            Consumer<GetDataIntegrationFlowRequest.Builder> getDataIntegrationFlowRequest) {
        return getDataIntegrationFlow(GetDataIntegrationFlowRequest.builder().applyMutation(getDataIntegrationFlowRequest)
                .build());
    }

    /**
     * <p>
     * Get the flow execution.
     * </p>
     *
     * @param getDataIntegrationFlowExecutionRequest
     *        The request parameters of GetFlowExecution.
     * @return A Java Future containing the result of the GetDataIntegrationFlowExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetDataIntegrationFlowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationFlowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataIntegrationFlowExecutionResponse> getDataIntegrationFlowExecution(
            GetDataIntegrationFlowExecutionRequest getDataIntegrationFlowExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the flow execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataIntegrationFlowExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link GetDataIntegrationFlowExecutionRequest#builder()}
     * </p>
     *
     * @param getDataIntegrationFlowExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataIntegrationFlowExecutionRequest.Builder}
     *        to create a request. The request parameters of GetFlowExecution.
     * @return A Java Future containing the result of the GetDataIntegrationFlowExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetDataIntegrationFlowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataIntegrationFlowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataIntegrationFlowExecutionResponse> getDataIntegrationFlowExecution(
            Consumer<GetDataIntegrationFlowExecutionRequest.Builder> getDataIntegrationFlowExecutionRequest) {
        return getDataIntegrationFlowExecution(GetDataIntegrationFlowExecutionRequest.builder()
                .applyMutation(getDataIntegrationFlowExecutionRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain data lake dataset. Developers can view
     * the data lake dataset information such as namespace, schema, and so on for a given instance ID, namespace, and
     * dataset name.
     * </p>
     *
     * @param getDataLakeDatasetRequest
     *        The request parameters for GetDataLakeDataset.
     * @return A Java Future containing the result of the GetDataLakeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataLakeDatasetResponse> getDataLakeDataset(GetDataLakeDatasetRequest getDataLakeDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain data lake dataset. Developers can view
     * the data lake dataset information such as namespace, schema, and so on for a given instance ID, namespace, and
     * dataset name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param getDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters for GetDataLakeDataset.
     * @return A Java Future containing the result of the GetDataLakeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataLakeDatasetResponse> getDataLakeDataset(
            Consumer<GetDataLakeDatasetRequest.Builder> getDataLakeDatasetRequest) {
        return getDataLakeDataset(GetDataLakeDatasetRequest.builder().applyMutation(getDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain data lake namespace. Developers can view
     * the data lake namespace information such as description for a given instance ID and namespace name.
     * </p>
     *
     * @param getDataLakeNamespaceRequest
     *        The request parameters for GetDataLakeNamespace.
     * @return A Java Future containing the result of the GetDataLakeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataLakeNamespaceResponse> getDataLakeNamespace(
            GetDataLakeNamespaceRequest getDataLakeNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view an Amazon Web Services Supply Chain data lake namespace. Developers can view
     * the data lake namespace information such as description for a given instance ID and namespace name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataLakeNamespaceRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataLakeNamespaceRequest#builder()}
     * </p>
     *
     * @param getDataLakeNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetDataLakeNamespaceRequest.Builder} to create a
     *        request. The request parameters for GetDataLakeNamespace.
     * @return A Java Future containing the result of the GetDataLakeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataLakeNamespaceResponse> getDataLakeNamespace(
            Consumer<GetDataLakeNamespaceRequest.Builder> getDataLakeNamespaceRequest) {
        return getDataLakeNamespace(GetDataLakeNamespaceRequest.builder().applyMutation(getDataLakeNamespaceRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically retrieve the information related to an Amazon Web Services Supply Chain instance
     * ID.
     * </p>
     *
     * @param getInstanceRequest
     *        The request parameters for GetInstance.
     * @return A Java Future containing the result of the GetInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstanceResponse> getInstance(GetInstanceRequest getInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically retrieve the information related to an Amazon Web Services Supply Chain instance
     * ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link GetInstanceRequest#builder()}
     * </p>
     *
     * @param getInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.GetInstanceRequest.Builder} to create a request.
     *        The request parameters for GetInstance.
     * @return A Java Future containing the result of the GetInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.GetInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstanceResponse> getInstance(Consumer<GetInstanceRequest.Builder> getInstanceRequest) {
        return getInstance(GetInstanceRequest.builder().applyMutation(getInstanceRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically list all data integration events for the provided Amazon Web Services Supply
     * Chain instance.
     * </p>
     *
     * @param listDataIntegrationEventsRequest
     *        The request parameters for ListDataIntegrationEvents.
     * @return A Java Future containing the result of the ListDataIntegrationEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIntegrationEventsResponse> listDataIntegrationEvents(
            ListDataIntegrationEventsRequest listDataIntegrationEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically list all data integration events for the provided Amazon Web Services Supply
     * Chain instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationEventsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataIntegrationEventsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest.Builder} to
     *        create a request. The request parameters for ListDataIntegrationEvents.
     * @return A Java Future containing the result of the ListDataIntegrationEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIntegrationEventsResponse> listDataIntegrationEvents(
            Consumer<ListDataIntegrationEventsRequest.Builder> listDataIntegrationEventsRequest) {
        return listDataIntegrationEvents(ListDataIntegrationEventsRequest.builder()
                .applyMutation(listDataIntegrationEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationEvents(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsPublisher publisher = client.listDataIntegrationEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsPublisher publisher = client.listDataIntegrationEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationEvents(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationEventsRequest
     *        The request parameters for ListDataIntegrationEvents.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationEventsPublisher listDataIntegrationEventsPaginator(
            ListDataIntegrationEventsRequest listDataIntegrationEventsRequest) {
        return new ListDataIntegrationEventsPublisher(this, listDataIntegrationEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationEvents(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsPublisher publisher = client.listDataIntegrationEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationEventsPublisher publisher = client.listDataIntegrationEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationEvents(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationEventsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataIntegrationEventsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest.Builder} to
     *        create a request. The request parameters for ListDataIntegrationEvents.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationEventsPublisher listDataIntegrationEventsPaginator(
            Consumer<ListDataIntegrationEventsRequest.Builder> listDataIntegrationEventsRequest) {
        return listDataIntegrationEventsPaginator(ListDataIntegrationEventsRequest.builder()
                .applyMutation(listDataIntegrationEventsRequest).build());
    }

    /**
     * <p>
     * List flow executions.
     * </p>
     *
     * @param listDataIntegrationFlowExecutionsRequest
     *        The request parameters of ListFlowExecutions.
     * @return A Java Future containing the result of the ListDataIntegrationFlowExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIntegrationFlowExecutionsResponse> listDataIntegrationFlowExecutions(
            ListDataIntegrationFlowExecutionsRequest listDataIntegrationFlowExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List flow executions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationFlowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataIntegrationFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest.Builder}
     *        to create a request. The request parameters of ListFlowExecutions.
     * @return A Java Future containing the result of the ListDataIntegrationFlowExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIntegrationFlowExecutionsResponse> listDataIntegrationFlowExecutions(
            Consumer<ListDataIntegrationFlowExecutionsRequest.Builder> listDataIntegrationFlowExecutionsRequest) {
        return listDataIntegrationFlowExecutions(ListDataIntegrationFlowExecutionsRequest.builder()
                .applyMutation(listDataIntegrationFlowExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationFlowExecutions(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsPublisher publisher = client.listDataIntegrationFlowExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsPublisher publisher = client.listDataIntegrationFlowExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationFlowExecutions(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationFlowExecutionsRequest
     *        The request parameters of ListFlowExecutions.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowExecutionsPublisher listDataIntegrationFlowExecutionsPaginator(
            ListDataIntegrationFlowExecutionsRequest listDataIntegrationFlowExecutionsRequest) {
        return new ListDataIntegrationFlowExecutionsPublisher(this, listDataIntegrationFlowExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationFlowExecutions(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsPublisher publisher = client.listDataIntegrationFlowExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowExecutionsPublisher publisher = client.listDataIntegrationFlowExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationFlowExecutions(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationFlowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataIntegrationFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowExecutionsRequest.Builder}
     *        to create a request. The request parameters of ListFlowExecutions.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowExecutionsPublisher listDataIntegrationFlowExecutionsPaginator(
            Consumer<ListDataIntegrationFlowExecutionsRequest.Builder> listDataIntegrationFlowExecutionsRequest) {
        return listDataIntegrationFlowExecutionsPaginator(ListDataIntegrationFlowExecutionsRequest.builder()
                .applyMutation(listDataIntegrationFlowExecutionsRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically list all data pipelines for the provided Amazon Web Services Supply Chain
     * instance.
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        The request parameters for ListDataIntegrationFlows.
     * @return A Java Future containing the result of the ListDataIntegrationFlows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIntegrationFlowsResponse> listDataIntegrationFlows(
            ListDataIntegrationFlowsRequest listDataIntegrationFlowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically list all data pipelines for the provided Amazon Web Services Supply Chain
     * instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationFlowsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataIntegrationFlowsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest.Builder} to
     *        create a request. The request parameters for ListDataIntegrationFlows.
     * @return A Java Future containing the result of the ListDataIntegrationFlows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIntegrationFlowsResponse> listDataIntegrationFlows(
            Consumer<ListDataIntegrationFlowsRequest.Builder> listDataIntegrationFlowsRequest) {
        return listDataIntegrationFlows(ListDataIntegrationFlowsRequest.builder().applyMutation(listDataIntegrationFlowsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsPublisher publisher = client.listDataIntegrationFlowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsPublisher publisher = client.listDataIntegrationFlowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        The request parameters for ListDataIntegrationFlows.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowsPublisher listDataIntegrationFlowsPaginator(
            ListDataIntegrationFlowsRequest listDataIntegrationFlowsRequest) {
        return new ListDataIntegrationFlowsPublisher(this, listDataIntegrationFlowsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsPublisher publisher = client.listDataIntegrationFlowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataIntegrationFlowsPublisher publisher = client.listDataIntegrationFlowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationFlows(software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationFlowsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataIntegrationFlowsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest.Builder} to
     *        create a request. The request parameters for ListDataIntegrationFlows.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataIntegrationFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationFlowsPublisher listDataIntegrationFlowsPaginator(
            Consumer<ListDataIntegrationFlowsRequest.Builder> listDataIntegrationFlowsRequest) {
        return listDataIntegrationFlowsPaginator(ListDataIntegrationFlowsRequest.builder()
                .applyMutation(listDataIntegrationFlowsRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically view the list of Amazon Web Services Supply Chain data lake datasets. Developers
     * can view the datasets and the corresponding information such as namespace, schema, and so on for a given instance
     * ID and namespace.
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        The request parameters of ListDataLakeDatasets.
     * @return A Java Future containing the result of the ListDataLakeDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataLakeDatasetsResponse> listDataLakeDatasets(
            ListDataLakeDatasetsRequest listDataLakeDatasetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view the list of Amazon Web Services Supply Chain data lake datasets. Developers
     * can view the datasets and the corresponding information such as namespace, schema, and so on for a given instance
     * ID and namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataLakeDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataLakeDatasetsRequest#builder()}
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest.Builder} to create a
     *        request. The request parameters of ListDataLakeDatasets.
     * @return A Java Future containing the result of the ListDataLakeDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataLakeDatasetsResponse> listDataLakeDatasets(
            Consumer<ListDataLakeDatasetsRequest.Builder> listDataLakeDatasetsRequest) {
        return listDataLakeDatasets(ListDataLakeDatasetsRequest.builder().applyMutation(listDataLakeDatasetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsPublisher publisher = client.listDataLakeDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsPublisher publisher = client.listDataLakeDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        The request parameters of ListDataLakeDatasets.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeDatasetsPublisher listDataLakeDatasetsPaginator(ListDataLakeDatasetsRequest listDataLakeDatasetsRequest) {
        return new ListDataLakeDatasetsPublisher(this, listDataLakeDatasetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsPublisher publisher = client.listDataLakeDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeDatasetsPublisher publisher = client.listDataLakeDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataLakeDatasets(software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataLakeDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataLakeDatasetsRequest#builder()}
     * </p>
     *
     * @param listDataLakeDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest.Builder} to create a
     *        request. The request parameters of ListDataLakeDatasets.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataLakeDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeDatasetsPublisher listDataLakeDatasetsPaginator(
            Consumer<ListDataLakeDatasetsRequest.Builder> listDataLakeDatasetsRequest) {
        return listDataLakeDatasetsPaginator(ListDataLakeDatasetsRequest.builder().applyMutation(listDataLakeDatasetsRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to programmatically view the list of Amazon Web Services Supply Chain data lake namespaces.
     * Developers can view the namespaces and the corresponding information such as description for a given instance ID.
     * Note that this API only return custom namespaces, instance pre-defined namespaces are not included.
     * </p>
     *
     * @param listDataLakeNamespacesRequest
     *        The request parameters of ListDataLakeNamespaces.
     * @return A Java Future containing the result of the ListDataLakeNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataLakeNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataLakeNamespacesResponse> listDataLakeNamespaces(
            ListDataLakeNamespacesRequest listDataLakeNamespacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically view the list of Amazon Web Services Supply Chain data lake namespaces.
     * Developers can view the namespaces and the corresponding information such as description for a given instance ID.
     * Note that this API only return custom namespaces, instance pre-defined namespaces are not included.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataLakeNamespacesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataLakeNamespacesRequest#builder()}
     * </p>
     *
     * @param listDataLakeNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest.Builder} to create
     *        a request. The request parameters of ListDataLakeNamespaces.
     * @return A Java Future containing the result of the ListDataLakeNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataLakeNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataLakeNamespacesResponse> listDataLakeNamespaces(
            Consumer<ListDataLakeNamespacesRequest.Builder> listDataLakeNamespacesRequest) {
        return listDataLakeNamespaces(ListDataLakeNamespacesRequest.builder().applyMutation(listDataLakeNamespacesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataLakeNamespaces(software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesPublisher publisher = client.listDataLakeNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesPublisher publisher = client.listDataLakeNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataLakeNamespaces(software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataLakeNamespacesRequest
     *        The request parameters of ListDataLakeNamespaces.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataLakeNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeNamespacesPublisher listDataLakeNamespacesPaginator(
            ListDataLakeNamespacesRequest listDataLakeNamespacesRequest) {
        return new ListDataLakeNamespacesPublisher(this, listDataLakeNamespacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataLakeNamespaces(software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesPublisher publisher = client.listDataLakeNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListDataLakeNamespacesPublisher publisher = client.listDataLakeNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataLakeNamespaces(software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataLakeNamespacesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataLakeNamespacesRequest#builder()}
     * </p>
     *
     * @param listDataLakeNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListDataLakeNamespacesRequest.Builder} to create
     *        a request. The request parameters of ListDataLakeNamespaces.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListDataLakeNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataLakeNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataLakeNamespacesPublisher listDataLakeNamespacesPaginator(
            Consumer<ListDataLakeNamespacesRequest.Builder> listDataLakeNamespacesRequest) {
        return listDataLakeNamespacesPaginator(ListDataLakeNamespacesRequest.builder()
                .applyMutation(listDataLakeNamespacesRequest).build());
    }

    /**
     * <p>
     * List all Amazon Web Services Supply Chain instances for a specific account. Enables you to programmatically list
     * all Amazon Web Services Supply Chain instances based on their account ID, instance name, and state of the
     * instance (active or delete).
     * </p>
     *
     * @param listInstancesRequest
     *        The request parameters for ListInstances.
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(ListInstancesRequest listInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all Amazon Web Services Supply Chain instances for a specific account. Enables you to programmatically list
     * all Amazon Web Services Supply Chain instances based on their account ID, instance name, and state of the
     * instance (active or delete).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListInstancesRequest.Builder} to create a
     *        request. The request parameters for ListInstances.
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstances(software.amazon.awssdk.services.supplychain.model.ListInstancesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.supplychain.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     *        The request parameters for ListInstances.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesPublisher listInstancesPaginator(ListInstancesRequest listInstancesRequest) {
        return new ListInstancesPublisher(this, listInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstances(software.amazon.awssdk.services.supplychain.model.ListInstancesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.supplychain.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.supplychain.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.supplychain.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.supplychain.model.ListInstancesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListInstancesRequest.Builder} to create a
     *        request. The request parameters for ListInstances.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesPublisher listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * List all the tags for an Amazon Web ServicesSupply Chain resource. You can list all the tags added to a resource.
     * By listing the tags, developers can view the tag level information on a resource and perform actions such as,
     * deleting a resource associated with a particular tag.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request parameters of ListTagsForResource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the tags for an Amazon Web ServicesSupply Chain resource. You can list all the tags added to a resource.
     * By listing the tags, developers can view the tag level information on a resource and perform actions such as,
     * deleting a resource associated with a particular tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.ListTagsForResourceRequest.Builder} to create a
     *        request. The request parameters of ListTagsForResource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Send the data payload for the event with real-time data for analysis or monitoring. The real-time data events are
     * stored in an Amazon Web Services service before being processed and stored in data lake.
     * </p>
     *
     * @param sendDataIntegrationEventRequest
     *        The request parameters for SendDataIntegrationEvent.
     * @return A Java Future containing the result of the SendDataIntegrationEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.SendDataIntegrationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/SendDataIntegrationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendDataIntegrationEventResponse> sendDataIntegrationEvent(
            SendDataIntegrationEventRequest sendDataIntegrationEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Send the data payload for the event with real-time data for analysis or monitoring. The real-time data events are
     * stored in an Amazon Web Services service before being processed and stored in data lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendDataIntegrationEventRequest.Builder} avoiding
     * the need to create one manually via {@link SendDataIntegrationEventRequest#builder()}
     * </p>
     *
     * @param sendDataIntegrationEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.SendDataIntegrationEventRequest.Builder} to
     *        create a request. The request parameters for SendDataIntegrationEvent.
     * @return A Java Future containing the result of the SendDataIntegrationEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.SendDataIntegrationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/SendDataIntegrationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendDataIntegrationEventResponse> sendDataIntegrationEvent(
            Consumer<SendDataIntegrationEventRequest.Builder> sendDataIntegrationEventRequest) {
        return sendDataIntegrationEvent(SendDataIntegrationEventRequest.builder().applyMutation(sendDataIntegrationEventRequest)
                .build());
    }

    /**
     * <p>
     * You can create tags during or after creating a resource such as instance, data flow, or dataset in AWS Supply
     * chain. During the data ingestion process, you can add tags such as dev, test, or prod to data flows created
     * during the data ingestion process in the AWS Supply Chain datasets. You can use these tags to identify a group of
     * resources or a single resource used by the developer.
     * </p>
     *
     * @param tagResourceRequest
     *        The request parameters of TagResource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can create tags during or after creating a resource such as instance, data flow, or dataset in AWS Supply
     * chain. During the data ingestion process, you can add tags such as dev, test, or prod to data flows created
     * during the data ingestion process in the AWS Supply Chain datasets. You can use these tags to identify a group of
     * resources or a single resource used by the developer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.TagResourceRequest.Builder} to create a request.
     *        The request parameters of TagResource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * You can delete tags for an Amazon Web Services Supply chain resource such as instance, data flow, or dataset in
     * AWS Supply Chain. During the data ingestion process, you can delete tags such as dev, test, or prod to data flows
     * created during the data ingestion process in the AWS Supply Chain datasets.
     * </p>
     *
     * @param untagResourceRequest
     *        The request parameters of UntagResource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can delete tags for an Amazon Web Services Supply chain resource such as instance, data flow, or dataset in
     * AWS Supply Chain. During the data ingestion process, you can delete tags such as dev, test, or prod to data flows
     * created during the data ingestion process in the AWS Supply Chain datasets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UntagResourceRequest.Builder} to create a
     *        request. The request parameters of UntagResource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically update an existing data pipeline to ingest data from the source systems such as,
     * Amazon S3 buckets, to a predefined Amazon Web Services Supply Chain dataset (product, inbound_order) or a
     * temporary dataset along with the data transformation query provided with the API.
     * </p>
     *
     * @param updateDataIntegrationFlowRequest
     *        The request parameters for UpdateDataIntegrationFlow.
     * @return A Java Future containing the result of the UpdateDataIntegrationFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.UpdateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataIntegrationFlowResponse> updateDataIntegrationFlow(
            UpdateDataIntegrationFlowRequest updateDataIntegrationFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically update an existing data pipeline to ingest data from the source systems such as,
     * Amazon S3 buckets, to a predefined Amazon Web Services Supply Chain dataset (product, inbound_order) or a
     * temporary dataset along with the data transformation query provided with the API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataIntegrationFlowRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDataIntegrationFlowRequest#builder()}
     * </p>
     *
     * @param updateDataIntegrationFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UpdateDataIntegrationFlowRequest.Builder} to
     *        create a request. The request parameters for UpdateDataIntegrationFlow.
     * @return A Java Future containing the result of the UpdateDataIntegrationFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.UpdateDataIntegrationFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataIntegrationFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataIntegrationFlowResponse> updateDataIntegrationFlow(
            Consumer<UpdateDataIntegrationFlowRequest.Builder> updateDataIntegrationFlowRequest) {
        return updateDataIntegrationFlow(UpdateDataIntegrationFlowRequest.builder()
                .applyMutation(updateDataIntegrationFlowRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain data lake dataset. Developers can
     * update the description of a data lake dataset for a given instance ID, namespace, and dataset name.
     * </p>
     *
     * @param updateDataLakeDatasetRequest
     *        The request parameters of UpdateDataLakeDataset.
     * @return A Java Future containing the result of the UpdateDataLakeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.UpdateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataLakeDatasetResponse> updateDataLakeDataset(
            UpdateDataLakeDatasetRequest updateDataLakeDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain data lake dataset. Developers can
     * update the description of a data lake dataset for a given instance ID, namespace, and dataset name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataLakeDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDataLakeDatasetRequest#builder()}
     * </p>
     *
     * @param updateDataLakeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UpdateDataLakeDatasetRequest.Builder} to create a
     *        request. The request parameters of UpdateDataLakeDataset.
     * @return A Java Future containing the result of the UpdateDataLakeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.UpdateDataLakeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataLakeDatasetResponse> updateDataLakeDataset(
            Consumer<UpdateDataLakeDatasetRequest.Builder> updateDataLakeDatasetRequest) {
        return updateDataLakeDataset(UpdateDataLakeDatasetRequest.builder().applyMutation(updateDataLakeDatasetRequest).build());
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain data lake namespace. Developers can
     * update the description of a data lake namespace for a given instance ID and namespace name.
     * </p>
     *
     * @param updateDataLakeNamespaceRequest
     *        The request parameters of UpdateDataLakeNamespace.
     * @return A Java Future containing the result of the UpdateDataLakeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.UpdateDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataLakeNamespaceResponse> updateDataLakeNamespace(
            UpdateDataLakeNamespaceRequest updateDataLakeNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain data lake namespace. Developers can
     * update the description of a data lake namespace for a given instance ID and namespace name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataLakeNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDataLakeNamespaceRequest#builder()}
     * </p>
     *
     * @param updateDataLakeNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UpdateDataLakeNamespaceRequest.Builder} to create
     *        a request. The request parameters of UpdateDataLakeNamespace.
     * @return A Java Future containing the result of the UpdateDataLakeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.UpdateDataLakeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateDataLakeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataLakeNamespaceResponse> updateDataLakeNamespace(
            Consumer<UpdateDataLakeNamespaceRequest.Builder> updateDataLakeNamespaceRequest) {
        return updateDataLakeNamespace(UpdateDataLakeNamespaceRequest.builder().applyMutation(updateDataLakeNamespaceRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain instance description by providing all
     * the relevant information such as account ID, instance ID and so on without using the AWS console.
     * </p>
     *
     * @param updateInstanceRequest
     *        The request parameters for UpdateInstance.
     * @return A Java Future containing the result of the UpdateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.UpdateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateInstanceResponse> updateInstance(UpdateInstanceRequest updateInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to programmatically update an Amazon Web Services Supply Chain instance description by providing all
     * the relevant information such as account ID, instance ID and so on without using the AWS console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInstanceRequest#builder()}
     * </p>
     *
     * @param updateInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.supplychain.model.UpdateInstanceRequest.Builder} to create a
     *        request. The request parameters for UpdateInstance.
     * @return A Java Future containing the result of the UpdateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have the required privileges to perform this action.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupplyChainException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupplyChainAsyncClient.UpdateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateInstanceResponse> updateInstance(Consumer<UpdateInstanceRequest.Builder> updateInstanceRequest) {
        return updateInstance(UpdateInstanceRequest.builder().applyMutation(updateInstanceRequest).build());
    }

    @Override
    default SupplyChainServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SupplyChainAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SupplyChainAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SupplyChainAsyncClient}.
     */
    static SupplyChainAsyncClientBuilder builder() {
        return new DefaultSupplyChainAsyncClientBuilder();
    }
}
