/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target dataset details for a DATASET event type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationEventDatasetTargetDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationEventDatasetTargetDetails.Builder, DataIntegrationEventDatasetTargetDetails> {
    private static final SdkField<String> DATASET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetIdentifier").getter(getter(DataIntegrationEventDatasetTargetDetails::datasetIdentifier))
            .setter(setter(Builder::datasetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetIdentifier").build()).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationType").getter(getter(DataIntegrationEventDatasetTargetDetails::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()).build();

    private static final SdkField<DataIntegrationEventDatasetLoadExecutionDetails> DATASET_LOAD_EXECUTION_FIELD = SdkField
            .<DataIntegrationEventDatasetLoadExecutionDetails> builder(MarshallingType.SDK_POJO)
            .memberName("datasetLoadExecution").getter(getter(DataIntegrationEventDatasetTargetDetails::datasetLoadExecution))
            .setter(setter(Builder::datasetLoadExecution)).constructor(DataIntegrationEventDatasetLoadExecutionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetLoadExecution").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IDENTIFIER_FIELD,
            OPERATION_TYPE_FIELD, DATASET_LOAD_EXECUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datasetIdentifier;

    private final String operationType;

    private final DataIntegrationEventDatasetLoadExecutionDetails datasetLoadExecution;

    private DataIntegrationEventDatasetTargetDetails(BuilderImpl builder) {
        this.datasetIdentifier = builder.datasetIdentifier;
        this.operationType = builder.operationType;
        this.datasetLoadExecution = builder.datasetLoadExecution;
    }

    /**
     * <p>
     * The datalake dataset ARN identifier.
     * </p>
     * 
     * @return The datalake dataset ARN identifier.
     */
    public final String datasetIdentifier() {
        return datasetIdentifier;
    }

    /**
     * <p>
     * The target dataset load operation type. The available options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>APPEND</b> - Add new records to the dataset. Noted that this operation type will just try to append records
     * as-is without any primary key or partition constraints.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPSERT</b> - Modify existing records in the dataset with primary key configured, events for datasets without
     * primary keys are not allowed. If event data contains primary keys that match records in the dataset within same
     * partition, then those existing records (in that partition) will be updated. If primary keys do not match, new
     * records will be added. Note that if dataset contain records with duplicate primary key values in the same
     * partition, those duplicate records will be deduped into one updated record.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETE</b> - Remove existing records in the dataset with primary key configured, events for datasets without
     * primary keys are not allowed. If event data contains primary keys that match records in the dataset within same
     * partition, then those existing records (in that partition) will be deleted. If primary keys do not match, no
     * actions will be done. Note that if dataset contain records with duplicate primary key values in the same
     * partition, all those duplicates will be removed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link DataIntegrationEventDatasetOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The target dataset load operation type. The available options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>APPEND</b> - Add new records to the dataset. Noted that this operation type will just try to append
     *         records as-is without any primary key or partition constraints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPSERT</b> - Modify existing records in the dataset with primary key configured, events for datasets
     *         without primary keys are not allowed. If event data contains primary keys that match records in the
     *         dataset within same partition, then those existing records (in that partition) will be updated. If
     *         primary keys do not match, new records will be added. Note that if dataset contain records with duplicate
     *         primary key values in the same partition, those duplicate records will be deduped into one updated
     *         record.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETE</b> - Remove existing records in the dataset with primary key configured, events for datasets
     *         without primary keys are not allowed. If event data contains primary keys that match records in the
     *         dataset within same partition, then those existing records (in that partition) will be deleted. If
     *         primary keys do not match, no actions will be done. Note that if dataset contain records with duplicate
     *         primary key values in the same partition, all those duplicates will be removed.
     *         </p>
     *         </li>
     * @see DataIntegrationEventDatasetOperationType
     */
    public final DataIntegrationEventDatasetOperationType operationType() {
        return DataIntegrationEventDatasetOperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The target dataset load operation type. The available options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>APPEND</b> - Add new records to the dataset. Noted that this operation type will just try to append records
     * as-is without any primary key or partition constraints.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPSERT</b> - Modify existing records in the dataset with primary key configured, events for datasets without
     * primary keys are not allowed. If event data contains primary keys that match records in the dataset within same
     * partition, then those existing records (in that partition) will be updated. If primary keys do not match, new
     * records will be added. Note that if dataset contain records with duplicate primary key values in the same
     * partition, those duplicate records will be deduped into one updated record.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETE</b> - Remove existing records in the dataset with primary key configured, events for datasets without
     * primary keys are not allowed. If event data contains primary keys that match records in the dataset within same
     * partition, then those existing records (in that partition) will be deleted. If primary keys do not match, no
     * actions will be done. Note that if dataset contain records with duplicate primary key values in the same
     * partition, all those duplicates will be removed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link DataIntegrationEventDatasetOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The target dataset load operation type. The available options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>APPEND</b> - Add new records to the dataset. Noted that this operation type will just try to append
     *         records as-is without any primary key or partition constraints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPSERT</b> - Modify existing records in the dataset with primary key configured, events for datasets
     *         without primary keys are not allowed. If event data contains primary keys that match records in the
     *         dataset within same partition, then those existing records (in that partition) will be updated. If
     *         primary keys do not match, new records will be added. Note that if dataset contain records with duplicate
     *         primary key values in the same partition, those duplicate records will be deduped into one updated
     *         record.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETE</b> - Remove existing records in the dataset with primary key configured, events for datasets
     *         without primary keys are not allowed. If event data contains primary keys that match records in the
     *         dataset within same partition, then those existing records (in that partition) will be deleted. If
     *         primary keys do not match, no actions will be done. Note that if dataset contain records with duplicate
     *         primary key values in the same partition, all those duplicates will be removed.
     *         </p>
     *         </li>
     * @see DataIntegrationEventDatasetOperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The target dataset load execution.
     * </p>
     * 
     * @return The target dataset load execution.
     */
    public final DataIntegrationEventDatasetLoadExecutionDetails datasetLoadExecution() {
        return datasetLoadExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetLoadExecution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationEventDatasetTargetDetails)) {
            return false;
        }
        DataIntegrationEventDatasetTargetDetails other = (DataIntegrationEventDatasetTargetDetails) obj;
        return Objects.equals(datasetIdentifier(), other.datasetIdentifier())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(datasetLoadExecution(), other.datasetLoadExecution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationEventDatasetTargetDetails").add("DatasetIdentifier", datasetIdentifier())
                .add("OperationType", operationTypeAsString()).add("DatasetLoadExecution", datasetLoadExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetIdentifier":
            return Optional.ofNullable(clazz.cast(datasetIdentifier()));
        case "operationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "datasetLoadExecution":
            return Optional.ofNullable(clazz.cast(datasetLoadExecution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetIdentifier", DATASET_IDENTIFIER_FIELD);
        map.put("operationType", OPERATION_TYPE_FIELD);
        map.put("datasetLoadExecution", DATASET_LOAD_EXECUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationEventDatasetTargetDetails, T> g) {
        return obj -> g.apply((DataIntegrationEventDatasetTargetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationEventDatasetTargetDetails> {
        /**
         * <p>
         * The datalake dataset ARN identifier.
         * </p>
         * 
         * @param datasetIdentifier
         *        The datalake dataset ARN identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetIdentifier(String datasetIdentifier);

        /**
         * <p>
         * The target dataset load operation type. The available options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>APPEND</b> - Add new records to the dataset. Noted that this operation type will just try to append
         * records as-is without any primary key or partition constraints.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPSERT</b> - Modify existing records in the dataset with primary key configured, events for datasets
         * without primary keys are not allowed. If event data contains primary keys that match records in the dataset
         * within same partition, then those existing records (in that partition) will be updated. If primary keys do
         * not match, new records will be added. Note that if dataset contain records with duplicate primary key values
         * in the same partition, those duplicate records will be deduped into one updated record.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETE</b> - Remove existing records in the dataset with primary key configured, events for datasets
         * without primary keys are not allowed. If event data contains primary keys that match records in the dataset
         * within same partition, then those existing records (in that partition) will be deleted. If primary keys do
         * not match, no actions will be done. Note that if dataset contain records with duplicate primary key values in
         * the same partition, all those duplicates will be removed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operationType
         *        The target dataset load operation type. The available options are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>APPEND</b> - Add new records to the dataset. Noted that this operation type will just try to append
         *        records as-is without any primary key or partition constraints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPSERT</b> - Modify existing records in the dataset with primary key configured, events for
         *        datasets without primary keys are not allowed. If event data contains primary keys that match records
         *        in the dataset within same partition, then those existing records (in that partition) will be updated.
         *        If primary keys do not match, new records will be added. Note that if dataset contain records with
         *        duplicate primary key values in the same partition, those duplicate records will be deduped into one
         *        updated record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETE</b> - Remove existing records in the dataset with primary key configured, events for
         *        datasets without primary keys are not allowed. If event data contains primary keys that match records
         *        in the dataset within same partition, then those existing records (in that partition) will be deleted.
         *        If primary keys do not match, no actions will be done. Note that if dataset contain records with
         *        duplicate primary key values in the same partition, all those duplicates will be removed.
         *        </p>
         *        </li>
         * @see DataIntegrationEventDatasetOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationEventDatasetOperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The target dataset load operation type. The available options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>APPEND</b> - Add new records to the dataset. Noted that this operation type will just try to append
         * records as-is without any primary key or partition constraints.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPSERT</b> - Modify existing records in the dataset with primary key configured, events for datasets
         * without primary keys are not allowed. If event data contains primary keys that match records in the dataset
         * within same partition, then those existing records (in that partition) will be updated. If primary keys do
         * not match, new records will be added. Note that if dataset contain records with duplicate primary key values
         * in the same partition, those duplicate records will be deduped into one updated record.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETE</b> - Remove existing records in the dataset with primary key configured, events for datasets
         * without primary keys are not allowed. If event data contains primary keys that match records in the dataset
         * within same partition, then those existing records (in that partition) will be deleted. If primary keys do
         * not match, no actions will be done. Note that if dataset contain records with duplicate primary key values in
         * the same partition, all those duplicates will be removed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operationType
         *        The target dataset load operation type. The available options are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>APPEND</b> - Add new records to the dataset. Noted that this operation type will just try to append
         *        records as-is without any primary key or partition constraints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPSERT</b> - Modify existing records in the dataset with primary key configured, events for
         *        datasets without primary keys are not allowed. If event data contains primary keys that match records
         *        in the dataset within same partition, then those existing records (in that partition) will be updated.
         *        If primary keys do not match, new records will be added. Note that if dataset contain records with
         *        duplicate primary key values in the same partition, those duplicate records will be deduped into one
         *        updated record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETE</b> - Remove existing records in the dataset with primary key configured, events for
         *        datasets without primary keys are not allowed. If event data contains primary keys that match records
         *        in the dataset within same partition, then those existing records (in that partition) will be deleted.
         *        If primary keys do not match, no actions will be done. Note that if dataset contain records with
         *        duplicate primary key values in the same partition, all those duplicates will be removed.
         *        </p>
         *        </li>
         * @see DataIntegrationEventDatasetOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationEventDatasetOperationType
         */
        Builder operationType(DataIntegrationEventDatasetOperationType operationType);

        /**
         * <p>
         * The target dataset load execution.
         * </p>
         * 
         * @param datasetLoadExecution
         *        The target dataset load execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetLoadExecution(DataIntegrationEventDatasetLoadExecutionDetails datasetLoadExecution);

        /**
         * <p>
         * The target dataset load execution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationEventDatasetLoadExecutionDetails.Builder} avoiding the need to create one manually via
         * {@link DataIntegrationEventDatasetLoadExecutionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationEventDatasetLoadExecutionDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #datasetLoadExecution(DataIntegrationEventDatasetLoadExecutionDetails)}.
         * 
         * @param datasetLoadExecution
         *        a consumer that will call methods on {@link DataIntegrationEventDatasetLoadExecutionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetLoadExecution(DataIntegrationEventDatasetLoadExecutionDetails)
         */
        default Builder datasetLoadExecution(
                Consumer<DataIntegrationEventDatasetLoadExecutionDetails.Builder> datasetLoadExecution) {
            return datasetLoadExecution(DataIntegrationEventDatasetLoadExecutionDetails.builder()
                    .applyMutation(datasetLoadExecution).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String datasetIdentifier;

        private String operationType;

        private DataIntegrationEventDatasetLoadExecutionDetails datasetLoadExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationEventDatasetTargetDetails model) {
            datasetIdentifier(model.datasetIdentifier);
            operationType(model.operationType);
            datasetLoadExecution(model.datasetLoadExecution);
        }

        public final String getDatasetIdentifier() {
            return datasetIdentifier;
        }

        public final void setDatasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
        }

        @Override
        public final Builder datasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
            return this;
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(DataIntegrationEventDatasetOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final DataIntegrationEventDatasetLoadExecutionDetails.Builder getDatasetLoadExecution() {
            return datasetLoadExecution != null ? datasetLoadExecution.toBuilder() : null;
        }

        public final void setDatasetLoadExecution(DataIntegrationEventDatasetLoadExecutionDetails.BuilderImpl datasetLoadExecution) {
            this.datasetLoadExecution = datasetLoadExecution != null ? datasetLoadExecution.build() : null;
        }

        @Override
        public final Builder datasetLoadExecution(DataIntegrationEventDatasetLoadExecutionDetails datasetLoadExecution) {
            this.datasetLoadExecution = datasetLoadExecution;
            return this;
        }

        @Override
        public DataIntegrationEventDatasetTargetDetails build() {
            return new DataIntegrationEventDatasetTargetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
