/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The flow execution details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationFlowExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationFlowExecution.Builder, DataIntegrationFlowExecution> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(DataIntegrationFlowExecution::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowName").getter(getter(DataIntegrationFlowExecution::flowName)).setter(setter(Builder::flowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(DataIntegrationFlowExecution::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataIntegrationFlowExecution::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<DataIntegrationFlowExecutionSourceInfo> SOURCE_INFO_FIELD = SdkField
            .<DataIntegrationFlowExecutionSourceInfo> builder(MarshallingType.SDK_POJO).memberName("sourceInfo")
            .getter(getter(DataIntegrationFlowExecution::sourceInfo)).setter(setter(Builder::sourceInfo))
            .constructor(DataIntegrationFlowExecutionSourceInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceInfo").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(DataIntegrationFlowExecution::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(DataIntegrationFlowExecution::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(DataIntegrationFlowExecution::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<DataIntegrationFlowExecutionOutputMetadata> OUTPUT_METADATA_FIELD = SdkField
            .<DataIntegrationFlowExecutionOutputMetadata> builder(MarshallingType.SDK_POJO).memberName("outputMetadata")
            .getter(getter(DataIntegrationFlowExecution::outputMetadata)).setter(setter(Builder::outputMetadata))
            .constructor(DataIntegrationFlowExecutionOutputMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            FLOW_NAME_FIELD, EXECUTION_ID_FIELD, STATUS_FIELD, SOURCE_INFO_FIELD, MESSAGE_FIELD, START_TIME_FIELD,
            END_TIME_FIELD, OUTPUT_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String flowName;

    private final String executionId;

    private final String status;

    private final DataIntegrationFlowExecutionSourceInfo sourceInfo;

    private final String message;

    private final Instant startTime;

    private final Instant endTime;

    private final DataIntegrationFlowExecutionOutputMetadata outputMetadata;

    private DataIntegrationFlowExecution(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.flowName = builder.flowName;
        this.executionId = builder.executionId;
        this.status = builder.status;
        this.sourceInfo = builder.sourceInfo;
        this.message = builder.message;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.outputMetadata = builder.outputMetadata;
    }

    /**
     * <p>
     * The flow execution's instanceId.
     * </p>
     * 
     * @return The flow execution's instanceId.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The flow execution's flowName.
     * </p>
     * 
     * @return The flow execution's flowName.
     */
    public final String flowName() {
        return flowName;
    }

    /**
     * <p>
     * The flow executionId.
     * </p>
     * 
     * @return The flow executionId.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The status of flow execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataIntegrationFlowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of flow execution.
     * @see DataIntegrationFlowExecutionStatus
     */
    public final DataIntegrationFlowExecutionStatus status() {
        return DataIntegrationFlowExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of flow execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataIntegrationFlowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of flow execution.
     * @see DataIntegrationFlowExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The source information for a flow execution.
     * </p>
     * 
     * @return The source information for a flow execution.
     */
    public final DataIntegrationFlowExecutionSourceInfo sourceInfo() {
        return sourceInfo;
    }

    /**
     * <p>
     * The failure message (if any) of failed flow execution.
     * </p>
     * 
     * @return The failure message (if any) of failed flow execution.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The flow execution start timestamp.
     * </p>
     * 
     * @return The flow execution start timestamp.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The flow execution end timestamp.
     * </p>
     * 
     * @return The flow execution end timestamp.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The flow execution output metadata.
     * </p>
     * 
     * @return The flow execution output metadata.
     */
    public final DataIntegrationFlowExecutionOutputMetadata outputMetadata() {
        return outputMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(flowName());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceInfo());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(outputMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowExecution)) {
            return false;
        }
        DataIntegrationFlowExecution other = (DataIntegrationFlowExecution) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(flowName(), other.flowName())
                && Objects.equals(executionId(), other.executionId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sourceInfo(), other.sourceInfo()) && Objects.equals(message(), other.message())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(outputMetadata(), other.outputMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationFlowExecution").add("InstanceId", instanceId()).add("FlowName", flowName())
                .add("ExecutionId", executionId()).add("Status", statusAsString()).add("SourceInfo", sourceInfo())
                .add("Message", message()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("OutputMetadata", outputMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "flowName":
            return Optional.ofNullable(clazz.cast(flowName()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "sourceInfo":
            return Optional.ofNullable(clazz.cast(sourceInfo()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "outputMetadata":
            return Optional.ofNullable(clazz.cast(outputMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("flowName", FLOW_NAME_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("sourceInfo", SOURCE_INFO_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("outputMetadata", OUTPUT_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowExecution, T> g) {
        return obj -> g.apply((DataIntegrationFlowExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationFlowExecution> {
        /**
         * <p>
         * The flow execution's instanceId.
         * </p>
         * 
         * @param instanceId
         *        The flow execution's instanceId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The flow execution's flowName.
         * </p>
         * 
         * @param flowName
         *        The flow execution's flowName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowName(String flowName);

        /**
         * <p>
         * The flow executionId.
         * </p>
         * 
         * @param executionId
         *        The flow executionId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The status of flow execution.
         * </p>
         * 
         * @param status
         *        The status of flow execution.
         * @see DataIntegrationFlowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of flow execution.
         * </p>
         * 
         * @param status
         *        The status of flow execution.
         * @see DataIntegrationFlowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowExecutionStatus
         */
        Builder status(DataIntegrationFlowExecutionStatus status);

        /**
         * <p>
         * The source information for a flow execution.
         * </p>
         * 
         * @param sourceInfo
         *        The source information for a flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceInfo(DataIntegrationFlowExecutionSourceInfo sourceInfo);

        /**
         * <p>
         * The source information for a flow execution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationFlowExecutionSourceInfo.Builder} avoiding the need to create one manually via
         * {@link DataIntegrationFlowExecutionSourceInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowExecutionSourceInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceInfo(DataIntegrationFlowExecutionSourceInfo)}.
         * 
         * @param sourceInfo
         *        a consumer that will call methods on {@link DataIntegrationFlowExecutionSourceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceInfo(DataIntegrationFlowExecutionSourceInfo)
         */
        default Builder sourceInfo(Consumer<DataIntegrationFlowExecutionSourceInfo.Builder> sourceInfo) {
            return sourceInfo(DataIntegrationFlowExecutionSourceInfo.builder().applyMutation(sourceInfo).build());
        }

        /**
         * <p>
         * The failure message (if any) of failed flow execution.
         * </p>
         * 
         * @param message
         *        The failure message (if any) of failed flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The flow execution start timestamp.
         * </p>
         * 
         * @param startTime
         *        The flow execution start timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The flow execution end timestamp.
         * </p>
         * 
         * @param endTime
         *        The flow execution end timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The flow execution output metadata.
         * </p>
         * 
         * @param outputMetadata
         *        The flow execution output metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputMetadata(DataIntegrationFlowExecutionOutputMetadata outputMetadata);

        /**
         * <p>
         * The flow execution output metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationFlowExecutionOutputMetadata.Builder} avoiding the need to create one manually via
         * {@link DataIntegrationFlowExecutionOutputMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowExecutionOutputMetadata.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #outputMetadata(DataIntegrationFlowExecutionOutputMetadata)}.
         * 
         * @param outputMetadata
         *        a consumer that will call methods on {@link DataIntegrationFlowExecutionOutputMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputMetadata(DataIntegrationFlowExecutionOutputMetadata)
         */
        default Builder outputMetadata(Consumer<DataIntegrationFlowExecutionOutputMetadata.Builder> outputMetadata) {
            return outputMetadata(DataIntegrationFlowExecutionOutputMetadata.builder().applyMutation(outputMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String flowName;

        private String executionId;

        private String status;

        private DataIntegrationFlowExecutionSourceInfo sourceInfo;

        private String message;

        private Instant startTime;

        private Instant endTime;

        private DataIntegrationFlowExecutionOutputMetadata outputMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowExecution model) {
            instanceId(model.instanceId);
            flowName(model.flowName);
            executionId(model.executionId);
            status(model.status);
            sourceInfo(model.sourceInfo);
            message(model.message);
            startTime(model.startTime);
            endTime(model.endTime);
            outputMetadata(model.outputMetadata);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getFlowName() {
            return flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataIntegrationFlowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DataIntegrationFlowExecutionSourceInfo.Builder getSourceInfo() {
            return sourceInfo != null ? sourceInfo.toBuilder() : null;
        }

        public final void setSourceInfo(DataIntegrationFlowExecutionSourceInfo.BuilderImpl sourceInfo) {
            this.sourceInfo = sourceInfo != null ? sourceInfo.build() : null;
        }

        @Override
        public final Builder sourceInfo(DataIntegrationFlowExecutionSourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final DataIntegrationFlowExecutionOutputMetadata.Builder getOutputMetadata() {
            return outputMetadata != null ? outputMetadata.toBuilder() : null;
        }

        public final void setOutputMetadata(DataIntegrationFlowExecutionOutputMetadata.BuilderImpl outputMetadata) {
            this.outputMetadata = outputMetadata != null ? outputMetadata.build() : null;
        }

        @Override
        public final Builder outputMetadata(DataIntegrationFlowExecutionOutputMetadata outputMetadata) {
            this.outputMetadata = outputMetadata;
            return this;
        }

        @Override
        public DataIntegrationFlowExecution build() {
            return new DataIntegrationFlowExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
