/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source information of a flow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationFlowExecutionSourceInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationFlowExecutionSourceInfo.Builder, DataIntegrationFlowExecutionSourceInfo> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceType").getter(getter(DataIntegrationFlowExecutionSourceInfo::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final SdkField<DataIntegrationFlowS3Source> S3_SOURCE_FIELD = SdkField
            .<DataIntegrationFlowS3Source> builder(MarshallingType.SDK_POJO).memberName("s3Source")
            .getter(getter(DataIntegrationFlowExecutionSourceInfo::s3Source)).setter(setter(Builder::s3Source))
            .constructor(DataIntegrationFlowS3Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Source").build()).build();

    private static final SdkField<DataIntegrationFlowDatasetSource> DATASET_SOURCE_FIELD = SdkField
            .<DataIntegrationFlowDatasetSource> builder(MarshallingType.SDK_POJO).memberName("datasetSource")
            .getter(getter(DataIntegrationFlowExecutionSourceInfo::datasetSource)).setter(setter(Builder::datasetSource))
            .constructor(DataIntegrationFlowDatasetSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            S3_SOURCE_FIELD, DATASET_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private final DataIntegrationFlowS3Source s3Source;

    private final DataIntegrationFlowDatasetSource datasetSource;

    private DataIntegrationFlowExecutionSourceInfo(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.s3Source = builder.s3Source;
        this.datasetSource = builder.datasetSource;
    }

    /**
     * <p>
     * The data integration flow execution source type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link DataIntegrationFlowSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The data integration flow execution source type.
     * @see DataIntegrationFlowSourceType
     */
    public final DataIntegrationFlowSourceType sourceType() {
        return DataIntegrationFlowSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The data integration flow execution source type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link DataIntegrationFlowSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The data integration flow execution source type.
     * @see DataIntegrationFlowSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * The source details of a flow execution with S3 source.
     * </p>
     * 
     * @return The source details of a flow execution with S3 source.
     */
    public final DataIntegrationFlowS3Source s3Source() {
        return s3Source;
    }

    /**
     * <p>
     * The source details of a flow execution with dataset source.
     * </p>
     * 
     * @return The source details of a flow execution with dataset source.
     */
    public final DataIntegrationFlowDatasetSource datasetSource() {
        return datasetSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Source());
        hashCode = 31 * hashCode + Objects.hashCode(datasetSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowExecutionSourceInfo)) {
            return false;
        }
        DataIntegrationFlowExecutionSourceInfo other = (DataIntegrationFlowExecutionSourceInfo) obj;
        return Objects.equals(sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(s3Source(), other.s3Source())
                && Objects.equals(datasetSource(), other.datasetSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationFlowExecutionSourceInfo").add("SourceType", sourceTypeAsString())
                .add("S3Source", s3Source()).add("DatasetSource", datasetSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "s3Source":
            return Optional.ofNullable(clazz.cast(s3Source()));
        case "datasetSource":
            return Optional.ofNullable(clazz.cast(datasetSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceType", SOURCE_TYPE_FIELD);
        map.put("s3Source", S3_SOURCE_FIELD);
        map.put("datasetSource", DATASET_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowExecutionSourceInfo, T> g) {
        return obj -> g.apply((DataIntegrationFlowExecutionSourceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationFlowExecutionSourceInfo> {
        /**
         * <p>
         * The data integration flow execution source type.
         * </p>
         * 
         * @param sourceType
         *        The data integration flow execution source type.
         * @see DataIntegrationFlowSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The data integration flow execution source type.
         * </p>
         * 
         * @param sourceType
         *        The data integration flow execution source type.
         * @see DataIntegrationFlowSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowSourceType
         */
        Builder sourceType(DataIntegrationFlowSourceType sourceType);

        /**
         * <p>
         * The source details of a flow execution with S3 source.
         * </p>
         * 
         * @param s3Source
         *        The source details of a flow execution with S3 source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Source(DataIntegrationFlowS3Source s3Source);

        /**
         * <p>
         * The source details of a flow execution with S3 source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataIntegrationFlowS3Source.Builder}
         * avoiding the need to create one manually via {@link DataIntegrationFlowS3Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowS3Source.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Source(DataIntegrationFlowS3Source)}.
         * 
         * @param s3Source
         *        a consumer that will call methods on {@link DataIntegrationFlowS3Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Source(DataIntegrationFlowS3Source)
         */
        default Builder s3Source(Consumer<DataIntegrationFlowS3Source.Builder> s3Source) {
            return s3Source(DataIntegrationFlowS3Source.builder().applyMutation(s3Source).build());
        }

        /**
         * <p>
         * The source details of a flow execution with dataset source.
         * </p>
         * 
         * @param datasetSource
         *        The source details of a flow execution with dataset source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetSource(DataIntegrationFlowDatasetSource datasetSource);

        /**
         * <p>
         * The source details of a flow execution with dataset source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataIntegrationFlowDatasetSource.Builder}
         * avoiding the need to create one manually via {@link DataIntegrationFlowDatasetSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowDatasetSource.Builder#build()} is called
         * immediately and its result is passed to {@link #datasetSource(DataIntegrationFlowDatasetSource)}.
         * 
         * @param datasetSource
         *        a consumer that will call methods on {@link DataIntegrationFlowDatasetSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetSource(DataIntegrationFlowDatasetSource)
         */
        default Builder datasetSource(Consumer<DataIntegrationFlowDatasetSource.Builder> datasetSource) {
            return datasetSource(DataIntegrationFlowDatasetSource.builder().applyMutation(datasetSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private DataIntegrationFlowS3Source s3Source;

        private DataIntegrationFlowDatasetSource datasetSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowExecutionSourceInfo model) {
            sourceType(model.sourceType);
            s3Source(model.s3Source);
            datasetSource(model.datasetSource);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(DataIntegrationFlowSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final DataIntegrationFlowS3Source.Builder getS3Source() {
            return s3Source != null ? s3Source.toBuilder() : null;
        }

        public final void setS3Source(DataIntegrationFlowS3Source.BuilderImpl s3Source) {
            this.s3Source = s3Source != null ? s3Source.build() : null;
        }

        @Override
        public final Builder s3Source(DataIntegrationFlowS3Source s3Source) {
            this.s3Source = s3Source;
            return this;
        }

        public final DataIntegrationFlowDatasetSource.Builder getDatasetSource() {
            return datasetSource != null ? datasetSource.toBuilder() : null;
        }

        public final void setDatasetSource(DataIntegrationFlowDatasetSource.BuilderImpl datasetSource) {
            this.datasetSource = datasetSource != null ? datasetSource.build() : null;
        }

        @Override
        public final Builder datasetSource(DataIntegrationFlowDatasetSource datasetSource) {
            this.datasetSource = datasetSource;
            return this;
        }

        @Override
        public DataIntegrationFlowExecutionSourceInfo build() {
            return new DataIntegrationFlowExecutionSourceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
