/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field used in the field priority deduplication strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationFlowFieldPriorityDedupeField implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationFlowFieldPriorityDedupeField.Builder, DataIntegrationFlowFieldPriorityDedupeField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataIntegrationFlowFieldPriorityDedupeField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(DataIntegrationFlowFieldPriorityDedupeField::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String sortOrder;

    private DataIntegrationFlowFieldPriorityDedupeField(BuilderImpl builder) {
        this.name = builder.name;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The name of the deduplication field. Must exist in the dataset and not be a primary key.
     * </p>
     * 
     * @return The name of the deduplication field. Must exist in the dataset and not be a primary key.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The sort order for the deduplication field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link DataIntegrationFlowFieldPriorityDedupeSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for the deduplication field.
     * @see DataIntegrationFlowFieldPriorityDedupeSortOrder
     */
    public final DataIntegrationFlowFieldPriorityDedupeSortOrder sortOrder() {
        return DataIntegrationFlowFieldPriorityDedupeSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for the deduplication field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link DataIntegrationFlowFieldPriorityDedupeSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for the deduplication field.
     * @see DataIntegrationFlowFieldPriorityDedupeSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowFieldPriorityDedupeField)) {
            return false;
        }
        DataIntegrationFlowFieldPriorityDedupeField other = (DataIntegrationFlowFieldPriorityDedupeField) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationFlowFieldPriorityDedupeField").add("Name", name())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowFieldPriorityDedupeField, T> g) {
        return obj -> g.apply((DataIntegrationFlowFieldPriorityDedupeField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationFlowFieldPriorityDedupeField> {
        /**
         * <p>
         * The name of the deduplication field. Must exist in the dataset and not be a primary key.
         * </p>
         * 
         * @param name
         *        The name of the deduplication field. Must exist in the dataset and not be a primary key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The sort order for the deduplication field.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for the deduplication field.
         * @see DataIntegrationFlowFieldPriorityDedupeSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowFieldPriorityDedupeSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for the deduplication field.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for the deduplication field.
         * @see DataIntegrationFlowFieldPriorityDedupeSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowFieldPriorityDedupeSortOrder
         */
        Builder sortOrder(DataIntegrationFlowFieldPriorityDedupeSortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowFieldPriorityDedupeField model) {
            name(model.name);
            sortOrder(model.sortOrder);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(DataIntegrationFlowFieldPriorityDedupeSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public DataIntegrationFlowFieldPriorityDedupeField build() {
            return new DataIntegrationFlowFieldPriorityDedupeField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
