/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DataIntegrationFlow source parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationFlowSource implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationFlowSource.Builder, DataIntegrationFlowSource> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceType").getter(getter(DataIntegrationFlowSource::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceName").getter(getter(DataIntegrationFlowSource::sourceName)).setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()).build();

    private static final SdkField<DataIntegrationFlowS3SourceConfiguration> S3_SOURCE_FIELD = SdkField
            .<DataIntegrationFlowS3SourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3Source")
            .getter(getter(DataIntegrationFlowSource::s3Source)).setter(setter(Builder::s3Source))
            .constructor(DataIntegrationFlowS3SourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Source").build()).build();

    private static final SdkField<DataIntegrationFlowDatasetSourceConfiguration> DATASET_SOURCE_FIELD = SdkField
            .<DataIntegrationFlowDatasetSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("datasetSource")
            .getter(getter(DataIntegrationFlowSource::datasetSource)).setter(setter(Builder::datasetSource))
            .constructor(DataIntegrationFlowDatasetSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            SOURCE_NAME_FIELD, S3_SOURCE_FIELD, DATASET_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private final String sourceName;

    private final DataIntegrationFlowS3SourceConfiguration s3Source;

    private final DataIntegrationFlowDatasetSourceConfiguration datasetSource;

    private DataIntegrationFlowSource(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.sourceName = builder.sourceName;
        this.s3Source = builder.s3Source;
        this.datasetSource = builder.datasetSource;
    }

    /**
     * <p>
     * The DataIntegrationFlow source type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link DataIntegrationFlowSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The DataIntegrationFlow source type.
     * @see DataIntegrationFlowSourceType
     */
    public final DataIntegrationFlowSourceType sourceType() {
        return DataIntegrationFlowSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The DataIntegrationFlow source type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link DataIntegrationFlowSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The DataIntegrationFlow source type.
     * @see DataIntegrationFlowSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * The DataIntegrationFlow source name that can be used as table alias in SQL transformation query.
     * </p>
     * 
     * @return The DataIntegrationFlow source name that can be used as table alias in SQL transformation query.
     */
    public final String sourceName() {
        return sourceName;
    }

    /**
     * <p>
     * The S3 DataIntegrationFlow source.
     * </p>
     * 
     * @return The S3 DataIntegrationFlow source.
     */
    public final DataIntegrationFlowS3SourceConfiguration s3Source() {
        return s3Source;
    }

    /**
     * <p>
     * The dataset DataIntegrationFlow source.
     * </p>
     * 
     * @return The dataset DataIntegrationFlow source.
     */
    public final DataIntegrationFlowDatasetSourceConfiguration datasetSource() {
        return datasetSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Source());
        hashCode = 31 * hashCode + Objects.hashCode(datasetSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowSource)) {
            return false;
        }
        DataIntegrationFlowSource other = (DataIntegrationFlowSource) obj;
        return Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(sourceName(), other.sourceName()) && Objects.equals(s3Source(), other.s3Source())
                && Objects.equals(datasetSource(), other.datasetSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationFlowSource").add("SourceType", sourceTypeAsString())
                .add("SourceName", sourceName()).add("S3Source", s3Source()).add("DatasetSource", datasetSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "sourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        case "s3Source":
            return Optional.ofNullable(clazz.cast(s3Source()));
        case "datasetSource":
            return Optional.ofNullable(clazz.cast(datasetSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceType", SOURCE_TYPE_FIELD);
        map.put("sourceName", SOURCE_NAME_FIELD);
        map.put("s3Source", S3_SOURCE_FIELD);
        map.put("datasetSource", DATASET_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowSource, T> g) {
        return obj -> g.apply((DataIntegrationFlowSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationFlowSource> {
        /**
         * <p>
         * The DataIntegrationFlow source type.
         * </p>
         * 
         * @param sourceType
         *        The DataIntegrationFlow source type.
         * @see DataIntegrationFlowSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The DataIntegrationFlow source type.
         * </p>
         * 
         * @param sourceType
         *        The DataIntegrationFlow source type.
         * @see DataIntegrationFlowSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationFlowSourceType
         */
        Builder sourceType(DataIntegrationFlowSourceType sourceType);

        /**
         * <p>
         * The DataIntegrationFlow source name that can be used as table alias in SQL transformation query.
         * </p>
         * 
         * @param sourceName
         *        The DataIntegrationFlow source name that can be used as table alias in SQL transformation query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * The S3 DataIntegrationFlow source.
         * </p>
         * 
         * @param s3Source
         *        The S3 DataIntegrationFlow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Source(DataIntegrationFlowS3SourceConfiguration s3Source);

        /**
         * <p>
         * The S3 DataIntegrationFlow source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationFlowS3SourceConfiguration.Builder} avoiding the need to create one manually via
         * {@link DataIntegrationFlowS3SourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowS3SourceConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #s3Source(DataIntegrationFlowS3SourceConfiguration)}.
         * 
         * @param s3Source
         *        a consumer that will call methods on {@link DataIntegrationFlowS3SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Source(DataIntegrationFlowS3SourceConfiguration)
         */
        default Builder s3Source(Consumer<DataIntegrationFlowS3SourceConfiguration.Builder> s3Source) {
            return s3Source(DataIntegrationFlowS3SourceConfiguration.builder().applyMutation(s3Source).build());
        }

        /**
         * <p>
         * The dataset DataIntegrationFlow source.
         * </p>
         * 
         * @param datasetSource
         *        The dataset DataIntegrationFlow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetSource(DataIntegrationFlowDatasetSourceConfiguration datasetSource);

        /**
         * <p>
         * The dataset DataIntegrationFlow source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataIntegrationFlowDatasetSourceConfiguration.Builder} avoiding the need to create one manually via
         * {@link DataIntegrationFlowDatasetSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataIntegrationFlowDatasetSourceConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #datasetSource(DataIntegrationFlowDatasetSourceConfiguration)}.
         * 
         * @param datasetSource
         *        a consumer that will call methods on {@link DataIntegrationFlowDatasetSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetSource(DataIntegrationFlowDatasetSourceConfiguration)
         */
        default Builder datasetSource(Consumer<DataIntegrationFlowDatasetSourceConfiguration.Builder> datasetSource) {
            return datasetSource(DataIntegrationFlowDatasetSourceConfiguration.builder().applyMutation(datasetSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private String sourceName;

        private DataIntegrationFlowS3SourceConfiguration s3Source;

        private DataIntegrationFlowDatasetSourceConfiguration datasetSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowSource model) {
            sourceType(model.sourceType);
            sourceName(model.sourceName);
            s3Source(model.s3Source);
            datasetSource(model.datasetSource);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(DataIntegrationFlowSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final DataIntegrationFlowS3SourceConfiguration.Builder getS3Source() {
            return s3Source != null ? s3Source.toBuilder() : null;
        }

        public final void setS3Source(DataIntegrationFlowS3SourceConfiguration.BuilderImpl s3Source) {
            this.s3Source = s3Source != null ? s3Source.build() : null;
        }

        @Override
        public final Builder s3Source(DataIntegrationFlowS3SourceConfiguration s3Source) {
            this.s3Source = s3Source;
            return this;
        }

        public final DataIntegrationFlowDatasetSourceConfiguration.Builder getDatasetSource() {
            return datasetSource != null ? datasetSource.toBuilder() : null;
        }

        public final void setDatasetSource(DataIntegrationFlowDatasetSourceConfiguration.BuilderImpl datasetSource) {
            this.datasetSource = datasetSource != null ? datasetSource.build() : null;
        }

        @Override
        public final Builder datasetSource(DataIntegrationFlowDatasetSourceConfiguration datasetSource) {
            this.datasetSource = datasetSource;
            return this;
        }

        @Override
        public DataIntegrationFlowSource build() {
            return new DataIntegrationFlowSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
