/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters for ListDataIntegrationEvents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataIntegrationEventsRequest extends SupplyChainRequest implements
        ToCopyableBuilder<ListDataIntegrationEventsRequest.Builder, ListDataIntegrationEventsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(ListDataIntegrationEventsRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("instanceId").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(ListDataIntegrationEventsRequest::eventTypeAsString))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("eventType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataIntegrationEventsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListDataIntegrationEventsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            EVENT_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String eventType;

    private final String nextToken;

    private final Integer maxResults;

    private ListDataIntegrationEventsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.eventType = builder.eventType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Web Services Supply Chain instance identifier.
     * </p>
     * 
     * @return The Amazon Web Services Supply Chain instance identifier.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * List data integration events for the specified eventType.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link DataIntegrationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return List data integration events for the specified eventType.
     * @see DataIntegrationEventType
     */
    public final DataIntegrationEventType eventType() {
        return DataIntegrationEventType.fromValue(eventType);
    }

    /**
     * <p>
     * List data integration events for the specified eventType.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link DataIntegrationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return List data integration events for the specified eventType.
     * @see DataIntegrationEventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The pagination token to fetch the next page of the data integration events.
     * </p>
     * 
     * @return The pagination token to fetch the next page of the data integration events.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specify the maximum number of data integration events to fetch in one paginated request.
     * </p>
     * 
     * @return Specify the maximum number of data integration events to fetch in one paginated request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataIntegrationEventsRequest)) {
            return false;
        }
        ListDataIntegrationEventsRequest other = (ListDataIntegrationEventsRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataIntegrationEventsRequest").add("InstanceId", instanceId())
                .add("EventType", eventTypeAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataIntegrationEventsRequest, T> g) {
        return obj -> g.apply((ListDataIntegrationEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SupplyChainRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataIntegrationEventsRequest> {
        /**
         * <p>
         * The Amazon Web Services Supply Chain instance identifier.
         * </p>
         * 
         * @param instanceId
         *        The Amazon Web Services Supply Chain instance identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * List data integration events for the specified eventType.
         * </p>
         * 
         * @param eventType
         *        List data integration events for the specified eventType.
         * @see DataIntegrationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationEventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * List data integration events for the specified eventType.
         * </p>
         * 
         * @param eventType
         *        List data integration events for the specified eventType.
         * @see DataIntegrationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIntegrationEventType
         */
        Builder eventType(DataIntegrationEventType eventType);

        /**
         * <p>
         * The pagination token to fetch the next page of the data integration events.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to fetch the next page of the data integration events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specify the maximum number of data integration events to fetch in one paginated request.
         * </p>
         * 
         * @param maxResults
         *        Specify the maximum number of data integration events to fetch in one paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupplyChainRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String eventType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataIntegrationEventsRequest model) {
            super(model);
            instanceId(model.instanceId);
            eventType(model.eventType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(DataIntegrationEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataIntegrationEventsRequest build() {
            return new ListDataIntegrationEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
