/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response parameters of ListDataLakeDatasets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataLakeDatasetsResponse extends SupplyChainResponse implements
        ToCopyableBuilder<ListDataLakeDatasetsResponse.Builder, ListDataLakeDatasetsResponse> {
    private static final SdkField<List<DataLakeDataset>> DATASETS_FIELD = SdkField
            .<List<DataLakeDataset>> builder(MarshallingType.LIST)
            .memberName("datasets")
            .getter(getter(ListDataLakeDatasetsResponse::datasets))
            .setter(setter(Builder::datasets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakeDataset> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakeDataset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataLakeDatasetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASETS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DataLakeDataset> datasets;

    private final String nextToken;

    private ListDataLakeDatasetsResponse(BuilderImpl builder) {
        super(builder);
        this.datasets = builder.datasets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Datasets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDatasets() {
        return datasets != null && !(datasets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of fetched dataset details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasets} method.
     * </p>
     * 
     * @return The list of fetched dataset details.
     */
    public final List<DataLakeDataset> datasets() {
        return datasets;
    }

    /**
     * <p>
     * The pagination token to fetch next page of datasets.
     * </p>
     * 
     * @return The pagination token to fetch next page of datasets.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasets() ? datasets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataLakeDatasetsResponse)) {
            return false;
        }
        ListDataLakeDatasetsResponse other = (ListDataLakeDatasetsResponse) obj;
        return hasDatasets() == other.hasDatasets() && Objects.equals(datasets(), other.datasets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataLakeDatasetsResponse").add("Datasets", hasDatasets() ? datasets() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasets":
            return Optional.ofNullable(clazz.cast(datasets()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasets", DATASETS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataLakeDatasetsResponse, T> g) {
        return obj -> g.apply((ListDataLakeDatasetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SupplyChainResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDataLakeDatasetsResponse> {
        /**
         * <p>
         * The list of fetched dataset details.
         * </p>
         * 
         * @param datasets
         *        The list of fetched dataset details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasets(Collection<DataLakeDataset> datasets);

        /**
         * <p>
         * The list of fetched dataset details.
         * </p>
         * 
         * @param datasets
         *        The list of fetched dataset details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasets(DataLakeDataset... datasets);

        /**
         * <p>
         * The list of fetched dataset details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.supplychain.model.DataLakeDataset.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.supplychain.model.DataLakeDataset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.supplychain.model.DataLakeDataset.Builder#build()} is called
         * immediately and its result is passed to {@link #datasets(List<DataLakeDataset>)}.
         * 
         * @param datasets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.supplychain.model.DataLakeDataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasets(java.util.Collection<DataLakeDataset>)
         */
        Builder datasets(Consumer<DataLakeDataset.Builder>... datasets);

        /**
         * <p>
         * The pagination token to fetch next page of datasets.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to fetch next page of datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SupplyChainResponse.BuilderImpl implements Builder {
        private List<DataLakeDataset> datasets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataLakeDatasetsResponse model) {
            super(model);
            datasets(model.datasets);
            nextToken(model.nextToken);
        }

        public final List<DataLakeDataset.Builder> getDatasets() {
            List<DataLakeDataset.Builder> result = DataLakeDatasetListCopier.copyToBuilder(this.datasets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasets(Collection<DataLakeDataset.BuilderImpl> datasets) {
            this.datasets = DataLakeDatasetListCopier.copyFromBuilder(datasets);
        }

        @Override
        public final Builder datasets(Collection<DataLakeDataset> datasets) {
            this.datasets = DataLakeDatasetListCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(DataLakeDataset... datasets) {
            datasets(Arrays.asList(datasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Consumer<DataLakeDataset.Builder>... datasets) {
            datasets(Stream.of(datasets).map(c -> DataLakeDataset.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataLakeDatasetsResponse build() {
            return new ListDataLakeDatasetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
