/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response parameters of UpdateDataLakeNamespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataLakeNamespaceResponse extends SupplyChainResponse implements
        ToCopyableBuilder<UpdateDataLakeNamespaceResponse.Builder, UpdateDataLakeNamespaceResponse> {
    private static final SdkField<DataLakeNamespace> NAMESPACE_FIELD = SdkField
            .<DataLakeNamespace> builder(MarshallingType.SDK_POJO).memberName("namespace")
            .getter(getter(UpdateDataLakeNamespaceResponse::namespace)).setter(setter(Builder::namespace))
            .constructor(DataLakeNamespace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DataLakeNamespace namespace;

    private UpdateDataLakeNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * The updated namespace details.
     * </p>
     * 
     * @return The updated namespace details.
     */
    public final DataLakeNamespace namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataLakeNamespaceResponse)) {
            return false;
        }
        UpdateDataLakeNamespaceResponse other = (UpdateDataLakeNamespaceResponse) obj;
        return Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataLakeNamespaceResponse").add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("namespace", NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataLakeNamespaceResponse, T> g) {
        return obj -> g.apply((UpdateDataLakeNamespaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SupplyChainResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDataLakeNamespaceResponse> {
        /**
         * <p>
         * The updated namespace details.
         * </p>
         * 
         * @param namespace
         *        The updated namespace details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(DataLakeNamespace namespace);

        /**
         * <p>
         * The updated namespace details.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeNamespace.Builder} avoiding the
         * need to create one manually via {@link DataLakeNamespace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeNamespace.Builder#build()} is called immediately and its
         * result is passed to {@link #namespace(DataLakeNamespace)}.
         * 
         * @param namespace
         *        a consumer that will call methods on {@link DataLakeNamespace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namespace(DataLakeNamespace)
         */
        default Builder namespace(Consumer<DataLakeNamespace.Builder> namespace) {
            return namespace(DataLakeNamespace.builder().applyMutation(namespace).build());
        }
    }

    static final class BuilderImpl extends SupplyChainResponse.BuilderImpl implements Builder {
        private DataLakeNamespace namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataLakeNamespaceResponse model) {
            super(model);
            namespace(model.namespace);
        }

        public final DataLakeNamespace.Builder getNamespace() {
            return namespace != null ? namespace.toBuilder() : null;
        }

        public final void setNamespace(DataLakeNamespace.BuilderImpl namespace) {
            this.namespace = namespace != null ? namespace.build() : null;
        }

        @Override
        public final Builder namespace(DataLakeNamespace namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public UpdateDataLakeNamespaceResponse build() {
            return new UpdateDataLakeNamespaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
