/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.AttachmentDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The file name and ID of an attachment to a case communication. You can use the ID to retrieve the attachment with the
 * <a>DescribeAttachment</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachmentDetails implements StructuredPojo, ToCopyableBuilder<AttachmentDetails.Builder, AttachmentDetails> {
    private final String attachmentId;

    private final String fileName;

    private AttachmentDetails(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.fileName = builder.fileName;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @return The ID of the attachment.
     */
    public String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The file name of the attachment.
     * </p>
     * 
     * @return The file name of the attachment.
     */
    public String fileName() {
        return fileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attachmentId() == null) ? 0 : attachmentId().hashCode());
        hashCode = 31 * hashCode + ((fileName() == null) ? 0 : fileName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentDetails)) {
            return false;
        }
        AttachmentDetails other = (AttachmentDetails) obj;
        if (other.attachmentId() == null ^ this.attachmentId() == null) {
            return false;
        }
        if (other.attachmentId() != null && !other.attachmentId().equals(this.attachmentId())) {
            return false;
        }
        if (other.fileName() == null ^ this.fileName() == null) {
            return false;
        }
        if (other.fileName() != null && !other.fileName().equals(this.fileName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attachmentId() != null) {
            sb.append("AttachmentId: ").append(attachmentId()).append(",");
        }
        if (fileName() != null) {
            sb.append("FileName: ").append(fileName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttachmentDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AttachmentDetails> {
        /**
         * <p>
         * The ID of the attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The file name of the attachment.
         * </p>
         * 
         * @param fileName
         *        The file name of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);
    }

    private static final class BuilderImpl implements Builder {
        private String attachmentId;

        private String fileName;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentDetails model) {
            setAttachmentId(model.attachmentId);
            setFileName(model.fileName);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final String getFileName() {
            return fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public AttachmentDetails build() {
            return new AttachmentDetails(this);
        }
    }
}
