/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content and file name of the attachment returned by the <a>DescribeAttachment</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAttachmentResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAttachmentResponse.Builder, DescribeAttachmentResponse> {
    private final Attachment attachment;

    private DescribeAttachmentResponse(BuilderImpl builder) {
        this.attachment = builder.attachment;
    }

    /**
     * <p>
     * The attachment content and file name.
     * </p>
     * 
     * @return The attachment content and file name.
     */
    public Attachment attachment() {
        return attachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attachment() == null) ? 0 : attachment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAttachmentResponse)) {
            return false;
        }
        DescribeAttachmentResponse other = (DescribeAttachmentResponse) obj;
        if (other.attachment() == null ^ this.attachment() == null) {
            return false;
        }
        if (other.attachment() != null && !other.attachment().equals(this.attachment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attachment() != null) {
            sb.append("Attachment: ").append(attachment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAttachmentResponse> {
        /**
         * <p>
         * The attachment content and file name.
         * </p>
         * 
         * @param attachment
         *        The attachment content and file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(Attachment attachment);
    }

    private static final class BuilderImpl implements Builder {
        private Attachment attachment;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAttachmentResponse model) {
            setAttachment(model.attachment);
        }

        public final Attachment getAttachment() {
            return attachment;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(Attachment attachment) {
            this.attachment = attachment;
        }

        @Override
        public DescribeAttachmentResponse build() {
            return new DescribeAttachmentResponse(this);
        }
    }
}
