/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The communications returned by the <a>DescribeCommunications</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCommunicationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeCommunicationsResponse.Builder, DescribeCommunicationsResponse> {
    private final List<Communication> communications;

    private final String nextToken;

    private DescribeCommunicationsResponse(BuilderImpl builder) {
        this.communications = builder.communications;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The communications for the case.
     * </p>
     * 
     * @return The communications for the case.
     */
    public List<Communication> communications() {
        return communications;
    }

    /**
     * <p>
     * A resumption point for pagination.
     * </p>
     * 
     * @return A resumption point for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((communications() == null) ? 0 : communications().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommunicationsResponse)) {
            return false;
        }
        DescribeCommunicationsResponse other = (DescribeCommunicationsResponse) obj;
        if (other.communications() == null ^ this.communications() == null) {
            return false;
        }
        if (other.communications() != null && !other.communications().equals(this.communications())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (communications() != null) {
            sb.append("Communications: ").append(communications()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeCommunicationsResponse> {
        /**
         * <p>
         * The communications for the case.
         * </p>
         * 
         * @param communications
         *        The communications for the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communications(Collection<Communication> communications);

        /**
         * <p>
         * The communications for the case.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setCommunications(java.util.Collection)} or {@link #withCommunications(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param communications
         *        The communications for the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communications(Communication... communications);

        /**
         * <p>
         * A resumption point for pagination.
         * </p>
         * 
         * @param nextToken
         *        A resumption point for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Communication> communications = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommunicationsResponse model) {
            setCommunications(model.communications);
            setNextToken(model.nextToken);
        }

        public final Collection<Communication> getCommunications() {
            return communications;
        }

        @Override
        public final Builder communications(Collection<Communication> communications) {
            this.communications = CommunicationListCopier.copy(communications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communications(Communication... communications) {
            if (this.communications == null) {
                this.communications = new SdkInternalList<>(communications.length);
            }
            for (Communication e : communications) {
                this.communications.add(e);
            }
            return this;
        }

        public final void setCommunications(Collection<Communication> communications) {
            this.communications = CommunicationListCopier.copy(communications);
        }

        @SafeVarargs
        public final void setCommunications(Communication... communications) {
            if (this.communications == null) {
                this.communications = new SdkInternalList<>(communications.length);
            }
            for (Communication e : communications) {
                this.communications.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeCommunicationsResponse build() {
            return new DescribeCommunicationsResponse(this);
        }
    }
}
