/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeServicesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeServicesRequest.Builder, DescribeServicesRequest> {
    private final List<String> serviceCodeList;

    private final String language;

    private DescribeServicesRequest(BuilderImpl builder) {
        this.serviceCodeList = builder.serviceCodeList;
        this.language = builder.language;
    }

    /**
     * <p>
     * A JSON-formatted list of service codes available for AWS services.
     * </p>
     * 
     * @return A JSON-formatted list of service codes available for AWS services.
     */
    public List<String> serviceCodeList() {
        return serviceCodeList;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en")
     * and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     * </p>
     * 
     * @return The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
     *         ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     */
    public String language() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((serviceCodeList() == null) ? 0 : serviceCodeList().hashCode());
        hashCode = 31 * hashCode + ((language() == null) ? 0 : language().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesRequest)) {
            return false;
        }
        DescribeServicesRequest other = (DescribeServicesRequest) obj;
        if (other.serviceCodeList() == null ^ this.serviceCodeList() == null) {
            return false;
        }
        if (other.serviceCodeList() != null && !other.serviceCodeList().equals(this.serviceCodeList())) {
            return false;
        }
        if (other.language() == null ^ this.language() == null) {
            return false;
        }
        if (other.language() != null && !other.language().equals(this.language())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (serviceCodeList() != null) {
            sb.append("ServiceCodeList: ").append(serviceCodeList()).append(",");
        }
        if (language() != null) {
            sb.append("Language: ").append(language()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeServicesRequest> {
        /**
         * <p>
         * A JSON-formatted list of service codes available for AWS services.
         * </p>
         * 
         * @param serviceCodeList
         *        A JSON-formatted list of service codes available for AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodeList(Collection<String> serviceCodeList);

        /**
         * <p>
         * A JSON-formatted list of service codes available for AWS services.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setServiceCodeList(java.util.Collection)} or {@link #withServiceCodeList(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param serviceCodeList
         *        A JSON-formatted list of service codes available for AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodeList(String... serviceCodeList);

        /**
         * <p>
         * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
         * ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
         *        English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that
         *        take them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> serviceCodeList = new SdkInternalList<>();

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesRequest model) {
            setServiceCodeList(model.serviceCodeList);
            setLanguage(model.language);
        }

        public final Collection<String> getServiceCodeList() {
            return serviceCodeList;
        }

        @Override
        public final Builder serviceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodeList(String... serviceCodeList) {
            if (this.serviceCodeList == null) {
                this.serviceCodeList = new SdkInternalList<>(serviceCodeList.length);
            }
            for (String e : serviceCodeList) {
                this.serviceCodeList.add(e);
            }
            return this;
        }

        public final void setServiceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
        }

        @SafeVarargs
        public final void setServiceCodeList(String... serviceCodeList) {
            if (this.serviceCodeList == null) {
                this.serviceCodeList = new SdkInternalList<>(serviceCodeList.length);
            }
            for (String e : serviceCodeList) {
                this.serviceCodeList.add(e);
            }
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public DescribeServicesRequest build() {
            return new DescribeServicesRequest(this);
        }
    }
}
