/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorChecks</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTrustedAdvisorChecksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeTrustedAdvisorChecksResponse.Builder, DescribeTrustedAdvisorChecksResponse> {
    private final List<TrustedAdvisorCheckDescription> checks;

    private DescribeTrustedAdvisorChecksResponse(BuilderImpl builder) {
        this.checks = builder.checks;
    }

    /**
     * <p>
     * Information about all available Trusted Advisor checks.
     * </p>
     * 
     * @return Information about all available Trusted Advisor checks.
     */
    public List<TrustedAdvisorCheckDescription> checks() {
        return checks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((checks() == null) ? 0 : checks().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorChecksResponse)) {
            return false;
        }
        DescribeTrustedAdvisorChecksResponse other = (DescribeTrustedAdvisorChecksResponse) obj;
        if (other.checks() == null ^ this.checks() == null) {
            return false;
        }
        if (other.checks() != null && !other.checks().equals(this.checks())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (checks() != null) {
            sb.append("Checks: ").append(checks()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTrustedAdvisorChecksResponse> {
        /**
         * <p>
         * Information about all available Trusted Advisor checks.
         * </p>
         * 
         * @param checks
         *        Information about all available Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checks(Collection<TrustedAdvisorCheckDescription> checks);

        /**
         * <p>
         * Information about all available Trusted Advisor checks.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setChecks(java.util.Collection)} or {@link #withChecks(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param checks
         *        Information about all available Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checks(TrustedAdvisorCheckDescription... checks);
    }

    private static final class BuilderImpl implements Builder {
        private List<TrustedAdvisorCheckDescription> checks = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorChecksResponse model) {
            setChecks(model.checks);
        }

        public final Collection<TrustedAdvisorCheckDescription> getChecks() {
            return checks;
        }

        @Override
        public final Builder checks(Collection<TrustedAdvisorCheckDescription> checks) {
            this.checks = TrustedAdvisorCheckListCopier.copy(checks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checks(TrustedAdvisorCheckDescription... checks) {
            if (this.checks == null) {
                this.checks = new SdkInternalList<>(checks.length);
            }
            for (TrustedAdvisorCheckDescription e : checks) {
                this.checks.add(e);
            }
            return this;
        }

        public final void setChecks(Collection<TrustedAdvisorCheckDescription> checks) {
            this.checks = TrustedAdvisorCheckListCopier.copy(checks);
        }

        @SafeVarargs
        public final void setChecks(TrustedAdvisorCheckDescription... checks) {
            if (this.checks == null) {
                this.checks = new SdkInternalList<>(checks.length);
            }
            for (TrustedAdvisorCheckDescription e : checks) {
                this.checks.add(e);
            }
        }

        @Override
        public DescribeTrustedAdvisorChecksResponse build() {
            return new DescribeTrustedAdvisorChecksResponse(this);
        }
    }
}
