/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class RefreshTrustedAdvisorCheckRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RefreshTrustedAdvisorCheckRequest.Builder, RefreshTrustedAdvisorCheckRequest> {
    private final String checkId;

    private RefreshTrustedAdvisorCheckRequest(BuilderImpl builder) {
        this.checkId = builder.checkId;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check to refresh. <b>Note:</b> Specifying the check ID of a check
     * that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check to refresh. <b>Note:</b> Specifying the check ID of a
     *         check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
     */
    public String checkId() {
        return checkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((checkId() == null) ? 0 : checkId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshTrustedAdvisorCheckRequest)) {
            return false;
        }
        RefreshTrustedAdvisorCheckRequest other = (RefreshTrustedAdvisorCheckRequest) obj;
        if (other.checkId() == null ^ this.checkId() == null) {
            return false;
        }
        if (other.checkId() != null && !other.checkId().equals(this.checkId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (checkId() != null) {
            sb.append("CheckId: ").append(checkId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RefreshTrustedAdvisorCheckRequest> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check to refresh. <b>Note:</b> Specifying the check ID of a
         * check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check to refresh. <b>Note:</b> Specifying the check ID
         *        of a check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);
    }

    private static final class BuilderImpl implements Builder {
        private String checkId;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshTrustedAdvisorCheckRequest model) {
            setCheckId(model.checkId);
        }

        public final String getCheckId() {
            return checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @Override
        public RefreshTrustedAdvisorCheckRequest build() {
            return new RefreshTrustedAdvisorCheckRequest(this);
        }
    }
}
