/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a Trusted Advisor check result, including the alert status, last refresh, and number of resources
 * examined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrustedAdvisorCheckSummary implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorCheckSummary.Builder, TrustedAdvisorCheckSummary> {
    private final String checkId;

    private final String timestamp;

    private final String status;

    private final Boolean hasFlaggedResources;

    private final TrustedAdvisorResourcesSummary resourcesSummary;

    private final TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

    private TrustedAdvisorCheckSummary(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
        this.hasFlaggedResources = builder.hasFlaggedResources;
        this.resourcesSummary = builder.resourcesSummary;
        this.categorySpecificSummary = builder.categorySpecificSummary;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The time of the last refresh of the check.
     * </p>
     * 
     * @return The time of the last refresh of the check.
     */
    public String timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     * </p>
     * 
     * @return The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Specifies whether the Trusted Advisor check has flagged resources.
     * </p>
     * 
     * @return Specifies whether the Trusted Advisor check has flagged resources.
     */
    public Boolean hasFlaggedResources() {
        return hasFlaggedResources;
    }

    /**
     *
     * @return
     */
    public TrustedAdvisorResourcesSummary resourcesSummary() {
        return resourcesSummary;
    }

    /**
     * <p>
     * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
     * currently supported.
     * </p>
     * 
     * @return Summary information that relates to the category of the check. Cost Optimizing is the only category that
     *         is currently supported.
     */
    public TrustedAdvisorCategorySpecificSummary categorySpecificSummary() {
        return categorySpecificSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((checkId() == null) ? 0 : checkId().hashCode());
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((hasFlaggedResources() == null) ? 0 : hasFlaggedResources().hashCode());
        hashCode = 31 * hashCode + ((resourcesSummary() == null) ? 0 : resourcesSummary().hashCode());
        hashCode = 31 * hashCode + ((categorySpecificSummary() == null) ? 0 : categorySpecificSummary().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckSummary)) {
            return false;
        }
        TrustedAdvisorCheckSummary other = (TrustedAdvisorCheckSummary) obj;
        if (other.checkId() == null ^ this.checkId() == null) {
            return false;
        }
        if (other.checkId() != null && !other.checkId().equals(this.checkId())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.hasFlaggedResources() == null ^ this.hasFlaggedResources() == null) {
            return false;
        }
        if (other.hasFlaggedResources() != null && !other.hasFlaggedResources().equals(this.hasFlaggedResources())) {
            return false;
        }
        if (other.resourcesSummary() == null ^ this.resourcesSummary() == null) {
            return false;
        }
        if (other.resourcesSummary() != null && !other.resourcesSummary().equals(this.resourcesSummary())) {
            return false;
        }
        if (other.categorySpecificSummary() == null ^ this.categorySpecificSummary() == null) {
            return false;
        }
        if (other.categorySpecificSummary() != null && !other.categorySpecificSummary().equals(this.categorySpecificSummary())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (checkId() != null) {
            sb.append("CheckId: ").append(checkId()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (hasFlaggedResources() != null) {
            sb.append("HasFlaggedResources: ").append(hasFlaggedResources()).append(",");
        }
        if (resourcesSummary() != null) {
            sb.append("ResourcesSummary: ").append(resourcesSummary()).append(",");
        }
        if (categorySpecificSummary() != null) {
            sb.append("CategorySpecificSummary: ").append(categorySpecificSummary()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorCheckSummary> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The time of the last refresh of the check.
         * </p>
         * 
         * @param timestamp
         *        The time of the last refresh of the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);

        /**
         * <p>
         * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         * </p>
         * 
         * @param status
         *        The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies whether the Trusted Advisor check has flagged resources.
         * </p>
         * 
         * @param hasFlaggedResources
         *        Specifies whether the Trusted Advisor check has flagged resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasFlaggedResources(Boolean hasFlaggedResources);

        /**
         *
         * @param resourcesSummary
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary);

        /**
         * <p>
         * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
         * currently supported.
         * </p>
         * 
         * @param categorySpecificSummary
         *        Summary information that relates to the category of the check. Cost Optimizing is the only category
         *        that is currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary);
    }

    private static final class BuilderImpl implements Builder {
        private String checkId;

        private String timestamp;

        private String status;

        private Boolean hasFlaggedResources;

        private TrustedAdvisorResourcesSummary resourcesSummary;

        private TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckSummary model) {
            setCheckId(model.checkId);
            setTimestamp(model.timestamp);
            setStatus(model.status);
            setHasFlaggedResources(model.hasFlaggedResources);
            setResourcesSummary(model.resourcesSummary);
            setCategorySpecificSummary(model.categorySpecificSummary);
        }

        public final String getCheckId() {
            return checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getHasFlaggedResources() {
            return hasFlaggedResources;
        }

        @Override
        public final Builder hasFlaggedResources(Boolean hasFlaggedResources) {
            this.hasFlaggedResources = hasFlaggedResources;
            return this;
        }

        public final void setHasFlaggedResources(Boolean hasFlaggedResources) {
            this.hasFlaggedResources = hasFlaggedResources;
        }

        public final TrustedAdvisorResourcesSummary getResourcesSummary() {
            return resourcesSummary;
        }

        @Override
        public final Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary) {
            this.resourcesSummary = resourcesSummary;
            return this;
        }

        public final void setResourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary) {
            this.resourcesSummary = resourcesSummary;
        }

        public final TrustedAdvisorCategorySpecificSummary getCategorySpecificSummary() {
            return categorySpecificSummary;
        }

        @Override
        public final Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary;
            return this;
        }

        public final void setCategorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary;
        }

        @Override
        public TrustedAdvisorCheckSummary build() {
            return new TrustedAdvisorCheckSummary(this);
        }
    }
}
