/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of severity levels returned by the <a>DescribeSeverityLevels</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSeverityLevelsResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeSeverityLevelsResponse.Builder, DescribeSeverityLevelsResponse> {
    private final List<SeverityLevel> severityLevels;

    private DescribeSeverityLevelsResponse(BuilderImpl builder) {
        super(builder);
        this.severityLevels = builder.severityLevels;
    }

    /**
     * <p>
     * The available severity levels for the support case. Available severity levels are defined by your service level
     * agreement with AWS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The available severity levels for the support case. Available severity levels are defined by your service
     *         level agreement with AWS.
     */
    public List<SeverityLevel> severityLevels() {
        return severityLevels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(severityLevels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSeverityLevelsResponse)) {
            return false;
        }
        DescribeSeverityLevelsResponse other = (DescribeSeverityLevelsResponse) obj;
        return Objects.equals(severityLevels(), other.severityLevels());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSeverityLevelsResponse").add("SeverityLevels", severityLevels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "severityLevels":
            return Optional.of(clazz.cast(severityLevels()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportResponse.Builder, CopyableBuilder<Builder, DescribeSeverityLevelsResponse> {
        /**
         * <p>
         * The available severity levels for the support case. Available severity levels are defined by your service
         * level agreement with AWS.
         * </p>
         * 
         * @param severityLevels
         *        The available severity levels for the support case. Available severity levels are defined by your
         *        service level agreement with AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLevels(Collection<SeverityLevel> severityLevels);

        /**
         * <p>
         * The available severity levels for the support case. Available severity levels are defined by your service
         * level agreement with AWS.
         * </p>
         * 
         * @param severityLevels
         *        The available severity levels for the support case. Available severity levels are defined by your
         *        service level agreement with AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLevels(SeverityLevel... severityLevels);

        /**
         * <p>
         * The available severity levels for the support case. Available severity levels are defined by your service
         * level agreement with AWS.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SeverityLevel>.Builder} avoiding the need
         * to create one manually via {@link List<SeverityLevel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SeverityLevel>.Builder#build()} is called immediately and
         * its result is passed to {@link #severityLevels(List<SeverityLevel>)}.
         * 
         * @param severityLevels
         *        a consumer that will call methods on {@link List<SeverityLevel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityLevels(List<SeverityLevel>)
         */
        Builder severityLevels(Consumer<SeverityLevel.Builder>... severityLevels);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<SeverityLevel> severityLevels;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSeverityLevelsResponse model) {
            super(model);
            severityLevels(model.severityLevels);
        }

        public final Collection<SeverityLevel.Builder> getSeverityLevels() {
            return severityLevels != null ? severityLevels.stream().map(SeverityLevel::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder severityLevels(Collection<SeverityLevel> severityLevels) {
            this.severityLevels = SeverityLevelsListCopier.copy(severityLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(SeverityLevel... severityLevels) {
            severityLevels(Arrays.asList(severityLevels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(Consumer<SeverityLevel.Builder>... severityLevels) {
            severityLevels(Stream.of(severityLevels).map(c -> SeverityLevel.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSeverityLevels(Collection<SeverityLevel.BuilderImpl> severityLevels) {
            this.severityLevels = SeverityLevelsListCopier.copyFromBuilder(severityLevels);
        }

        @Override
        public DescribeSeverityLevelsResponse build() {
            return new DescribeSeverityLevelsResponse(this);
        }
    }
}
