/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the Trusted Advisor check returned by the <a>DescribeTrustedAdvisorCheckResult</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTrustedAdvisorCheckResultResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeTrustedAdvisorCheckResultResponse.Builder, DescribeTrustedAdvisorCheckResultResponse> {
    private final TrustedAdvisorCheckResult result;

    private DescribeTrustedAdvisorCheckResultResponse(BuilderImpl builder) {
        super(builder);
        this.result = builder.result;
    }

    /**
     * <p>
     * The detailed results of the Trusted Advisor check.
     * </p>
     * 
     * @return The detailed results of the Trusted Advisor check.
     */
    public TrustedAdvisorCheckResult result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckResultResponse)) {
            return false;
        }
        DescribeTrustedAdvisorCheckResultResponse other = (DescribeTrustedAdvisorCheckResultResponse) obj;
        return Objects.equals(result(), other.result());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeTrustedAdvisorCheckResultResponse").add("Result", result()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "result":
            return Optional.of(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportResponse.Builder, CopyableBuilder<Builder, DescribeTrustedAdvisorCheckResultResponse> {
        /**
         * <p>
         * The detailed results of the Trusted Advisor check.
         * </p>
         * 
         * @param result
         *        The detailed results of the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(TrustedAdvisorCheckResult result);

        /**
         * <p>
         * The detailed results of the Trusted Advisor check.
         * </p>
         * This is a convenience that creates an instance of the {@link TrustedAdvisorCheckResult.Builder} avoiding the
         * need to create one manually via {@link TrustedAdvisorCheckResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedAdvisorCheckResult.Builder#build()} is called immediately
         * and its result is passed to {@link #result(TrustedAdvisorCheckResult)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link TrustedAdvisorCheckResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(TrustedAdvisorCheckResult)
         */
        default Builder result(Consumer<TrustedAdvisorCheckResult.Builder> result) {
            return result(TrustedAdvisorCheckResult.builder().apply(result).build());
        }
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private TrustedAdvisorCheckResult result;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckResultResponse model) {
            super(model);
            result(model.result);
        }

        public final TrustedAdvisorCheckResult.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        @Override
        public final Builder result(TrustedAdvisorCheckResult result) {
            this.result = result;
            return this;
        }

        public final void setResult(TrustedAdvisorCheckResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public DescribeTrustedAdvisorCheckResultResponse build() {
            return new DescribeTrustedAdvisorCheckResultResponse(this);
        }
    }
}
