/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the case returned by the <a>ResolveCase</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResolveCaseResponse extends SupportResponse implements
        ToCopyableBuilder<ResolveCaseResponse.Builder, ResolveCaseResponse> {
    private final String initialCaseStatus;

    private final String finalCaseStatus;

    private ResolveCaseResponse(BuilderImpl builder) {
        super(builder);
        this.initialCaseStatus = builder.initialCaseStatus;
        this.finalCaseStatus = builder.finalCaseStatus;
    }

    /**
     * <p>
     * The status of the case when the <a>ResolveCase</a> request was sent.
     * </p>
     * 
     * @return The status of the case when the <a>ResolveCase</a> request was sent.
     */
    public String initialCaseStatus() {
        return initialCaseStatus;
    }

    /**
     * <p>
     * The status of the case after the <a>ResolveCase</a> request was processed.
     * </p>
     * 
     * @return The status of the case after the <a>ResolveCase</a> request was processed.
     */
    public String finalCaseStatus() {
        return finalCaseStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialCaseStatus());
        hashCode = 31 * hashCode + Objects.hashCode(finalCaseStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveCaseResponse)) {
            return false;
        }
        ResolveCaseResponse other = (ResolveCaseResponse) obj;
        return Objects.equals(initialCaseStatus(), other.initialCaseStatus())
                && Objects.equals(finalCaseStatus(), other.finalCaseStatus());
    }

    @Override
    public String toString() {
        return ToString.builder("ResolveCaseResponse").add("InitialCaseStatus", initialCaseStatus())
                .add("FinalCaseStatus", finalCaseStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "initialCaseStatus":
            return Optional.of(clazz.cast(initialCaseStatus()));
        case "finalCaseStatus":
            return Optional.of(clazz.cast(finalCaseStatus()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportResponse.Builder, CopyableBuilder<Builder, ResolveCaseResponse> {
        /**
         * <p>
         * The status of the case when the <a>ResolveCase</a> request was sent.
         * </p>
         * 
         * @param initialCaseStatus
         *        The status of the case when the <a>ResolveCase</a> request was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialCaseStatus(String initialCaseStatus);

        /**
         * <p>
         * The status of the case after the <a>ResolveCase</a> request was processed.
         * </p>
         * 
         * @param finalCaseStatus
         *        The status of the case after the <a>ResolveCase</a> request was processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalCaseStatus(String finalCaseStatus);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private String initialCaseStatus;

        private String finalCaseStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveCaseResponse model) {
            super(model);
            initialCaseStatus(model.initialCaseStatus);
            finalCaseStatus(model.finalCaseStatus);
        }

        public final String getInitialCaseStatus() {
            return initialCaseStatus;
        }

        @Override
        public final Builder initialCaseStatus(String initialCaseStatus) {
            this.initialCaseStatus = initialCaseStatus;
            return this;
        }

        public final void setInitialCaseStatus(String initialCaseStatus) {
            this.initialCaseStatus = initialCaseStatus;
        }

        public final String getFinalCaseStatus() {
            return finalCaseStatus;
        }

        @Override
        public final Builder finalCaseStatus(String finalCaseStatus) {
            this.finalCaseStatus = finalCaseStatus;
            return this;
        }

        public final void setFinalCaseStatus(String finalCaseStatus) {
            this.finalCaseStatus = finalCaseStatus;
        }

        @Override
        public ResolveCaseResponse build() {
            return new ResolveCaseResponse(this);
        }
    }
}
