/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.CaseDetails;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CaseDetails} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CaseDetailsMarshaller {
    private static final MarshallingInfo<String> CASEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caseId").isBinary(false).build();

    private static final MarshallingInfo<String> DISPLAYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayId").isBinary(false).build();

    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subject").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final MarshallingInfo<String> SERVICECODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceCode").isBinary(false).build();

    private static final MarshallingInfo<String> CATEGORYCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("categoryCode").isBinary(false).build();

    private static final MarshallingInfo<String> SEVERITYCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("severityCode").isBinary(false).build();

    private static final MarshallingInfo<String> SUBMITTEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("submittedBy").isBinary(false).build();

    private static final MarshallingInfo<String> TIMECREATED_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeCreated").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RECENTCOMMUNICATIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("recentCommunications").isBinary(false).build();

    private static final MarshallingInfo<List> CCEMAILADDRESSES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ccEmailAddresses").isBinary(false).build();

    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").isBinary(false).build();

    private static final CaseDetailsMarshaller INSTANCE = new CaseDetailsMarshaller();

    private CaseDetailsMarshaller() {
    }

    public static CaseDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CaseDetails caseDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(caseDetails, "caseDetails");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(caseDetails.caseId(), CASEID_BINDING);
            protocolMarshaller.marshall(caseDetails.displayId(), DISPLAYID_BINDING);
            protocolMarshaller.marshall(caseDetails.subject(), SUBJECT_BINDING);
            protocolMarshaller.marshall(caseDetails.status(), STATUS_BINDING);
            protocolMarshaller.marshall(caseDetails.serviceCode(), SERVICECODE_BINDING);
            protocolMarshaller.marshall(caseDetails.categoryCode(), CATEGORYCODE_BINDING);
            protocolMarshaller.marshall(caseDetails.severityCode(), SEVERITYCODE_BINDING);
            protocolMarshaller.marshall(caseDetails.submittedBy(), SUBMITTEDBY_BINDING);
            protocolMarshaller.marshall(caseDetails.timeCreated(), TIMECREATED_BINDING);
            protocolMarshaller.marshall(caseDetails.recentCommunications(), RECENTCOMMUNICATIONS_BINDING);
            protocolMarshaller.marshall(caseDetails.ccEmailAddresses(), CCEMAILADDRESSES_BINDING);
            protocolMarshaller.marshall(caseDetails.language(), LANGUAGE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
