/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.SeverityLevelMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SeverityLevel
implements StructuredPojo,
ToCopyableBuilder<Builder, SeverityLevel> {
    private final String code;
    private final String name;

    private SeverityLevel(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
    }

    public String code() {
        return this.code;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeverityLevel)) {
            return false;
        }
        SeverityLevel other = (SeverityLevel)obj;
        return Objects.equals(this.code(), other.code()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"SeverityLevel").add("Code", (Object)this.code()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "code": {
                return Optional.of(clazz.cast(this.code()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SeverityLevelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SeverityLevel model) {
            this.code(model.code);
            this.name(model.name);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public SeverityLevel build() {
            return new SeverityLevel(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SeverityLevel> {
        public Builder code(String var1);

        public Builder name(String var1);
    }
}

