/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content and file name of the attachment returned by the <a>DescribeAttachment</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAttachmentResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeAttachmentResponse.Builder, DescribeAttachmentResponse> {
    private final Attachment attachment;

    private DescribeAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.attachment = builder.attachment;
    }

    /**
     * <p>
     * The attachment content and file name.
     * </p>
     * 
     * @return The attachment content and file name.
     */
    public Attachment attachment() {
        return attachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAttachmentResponse)) {
            return false;
        }
        DescribeAttachmentResponse other = (DescribeAttachmentResponse) obj;
        return Objects.equals(attachment(), other.attachment());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAttachmentResponse").add("Attachment", attachment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportResponse.Builder, CopyableBuilder<Builder, DescribeAttachmentResponse> {
        /**
         * <p>
         * The attachment content and file name.
         * </p>
         * 
         * @param attachment
         *        The attachment content and file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(Attachment attachment);

        /**
         * <p>
         * The attachment content and file name.
         * </p>
         * This is a convenience that creates an instance of the {@link Attachment.Builder} avoiding the need to create
         * one manually via {@link Attachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Attachment.Builder#build()} is called immediately and its result
         * is passed to {@link #attachment(Attachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link Attachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(Attachment)
         */
        default Builder attachment(Consumer<Attachment.Builder> attachment) {
            return attachment(Attachment.builder().applyMutation(attachment).build());
        }
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private Attachment attachment;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAttachmentResponse model) {
            super(model);
            attachment(model.attachment);
        }

        public final Attachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(Attachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public DescribeAttachmentResponse build() {
            return new DescribeAttachmentResponse(this);
        }
    }
}
