/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.transform.ServiceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an AWS service returned by the <a>DescribeServices</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements StructuredPojo, ToCopyableBuilder<Service.Builder, Service> {
    private final String code;

    private final String name;

    private final List<Category> categories;

    private Service(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
        this.categories = builder.categories;
    }

    /**
     * <p>
     * The code for an AWS service returned by the <a>DescribeServices</a> response. The <code>name</code> element
     * contains the corresponding friendly name.
     * </p>
     * 
     * @return The code for an AWS service returned by the <a>DescribeServices</a> response. The <code>name</code>
     *         element contains the corresponding friendly name.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * The friendly name for an AWS service. The <code>code</code> element contains the corresponding code.
     * </p>
     * 
     * @return The friendly name for an AWS service. The <code>code</code> element contains the corresponding code.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A list of categories that describe the type of support issue a case describes. Categories consist of a category
     * name and a category code. Category names and codes are passed to AWS Support when you call <a>CreateCase</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of categories that describe the type of support issue a case describes. Categories consist of a
     *         category name and a category code. Category names and codes are passed to AWS Support when you call
     *         <a>CreateCase</a>.
     */
    public List<Category> categories() {
        return categories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(categories());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(name(), other.name())
                && Objects.equals(categories(), other.categories());
    }

    @Override
    public String toString() {
        return ToString.builder("Service").add("Code", code()).add("Name", name()).add("Categories", categories()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "categories":
            return Optional.ofNullable(clazz.cast(categories()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * The code for an AWS service returned by the <a>DescribeServices</a> response. The <code>name</code> element
         * contains the corresponding friendly name.
         * </p>
         * 
         * @param code
         *        The code for an AWS service returned by the <a>DescribeServices</a> response. The <code>name</code>
         *        element contains the corresponding friendly name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The friendly name for an AWS service. The <code>code</code> element contains the corresponding code.
         * </p>
         * 
         * @param name
         *        The friendly name for an AWS service. The <code>code</code> element contains the corresponding code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of categories that describe the type of support issue a case describes. Categories consist of a
         * category name and a category code. Category names and codes are passed to AWS Support when you call
         * <a>CreateCase</a>.
         * </p>
         * 
         * @param categories
         *        A list of categories that describe the type of support issue a case describes. Categories consist of a
         *        category name and a category code. Category names and codes are passed to AWS Support when you call
         *        <a>CreateCase</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<Category> categories);

        /**
         * <p>
         * A list of categories that describe the type of support issue a case describes. Categories consist of a
         * category name and a category code. Category names and codes are passed to AWS Support when you call
         * <a>CreateCase</a>.
         * </p>
         * 
         * @param categories
         *        A list of categories that describe the type of support issue a case describes. Categories consist of a
         *        category name and a category code. Category names and codes are passed to AWS Support when you call
         *        <a>CreateCase</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Category... categories);

        /**
         * <p>
         * A list of categories that describe the type of support issue a case describes. Categories consist of a
         * category name and a category code. Category names and codes are passed to AWS Support when you call
         * <a>CreateCase</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Category>.Builder} avoiding the need to
         * create one manually via {@link List<Category>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Category>.Builder#build()} is called immediately and its
         * result is passed to {@link #categories(List<Category>)}.
         * 
         * @param categories
         *        a consumer that will call methods on {@link List<Category>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(List<Category>)
         */
        Builder categories(Consumer<Category.Builder>... categories);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String name;

        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            code(model.code);
            name(model.name);
            categories(model.categories);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Category.Builder> getCategories() {
            return categories != null ? categories.stream().map(Category::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder>... categories) {
            categories(Stream.of(categories).map(c -> Category.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public Service build() {
            return new Service(this);
        }
    }
}
