/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description and metadata for a Trusted Advisor check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedAdvisorCheckDescription implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorCheckDescription.Builder, TrustedAdvisorCheckDescription> {
    private final String id;

    private final String name;

    private final String description;

    private final String category;

    private final List<String> metadata;

    private TrustedAdvisorCheckDescription(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.category = builder.category;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The display name for the Trusted Advisor check.
     * </p>
     * 
     * @return The display name for the Trusted Advisor check.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the Trusted Advisor check, which includes the alert criteria and recommended actions (contains
     * HTML markup).
     * </p>
     * 
     * @return The description of the Trusted Advisor check, which includes the alert criteria and recommended actions
     *         (contains HTML markup).
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The category of the Trusted Advisor check.
     * </p>
     * 
     * @return The category of the Trusted Advisor check.
     */
    public String category() {
        return category;
    }

    /**
     * <p>
     * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to
     * the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the check.
     * <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows
     * just summary data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The column headings for the data returned by the Trusted Advisor check. The order of the headings
     *         corresponds to the order of the data in the <b>Metadata</b> element of the
     *         <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown in
     *         the Excel download, even in those cases where the UI shows just summary data.
     */
    public List<String> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckDescription)) {
            return false;
        }
        TrustedAdvisorCheckDescription other = (TrustedAdvisorCheckDescription) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(category(), other.category())
                && Objects.equals(metadata(), other.metadata());
    }

    @Override
    public String toString() {
        return ToString.builder("TrustedAdvisorCheckDescription").add("Id", id()).add("Name", name())
                .add("Description", description()).add("Category", category()).add("Metadata", metadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "category":
            return Optional.ofNullable(clazz.cast(category()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorCheckDescription> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param id
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The display name for the Trusted Advisor check.
         * </p>
         * 
         * @param name
         *        The display name for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the Trusted Advisor check, which includes the alert criteria and recommended actions
         * (contains HTML markup).
         * </p>
         * 
         * @param description
         *        The description of the Trusted Advisor check, which includes the alert criteria and recommended
         *        actions (contains HTML markup).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The category of the Trusted Advisor check.
         * </p>
         * 
         * @param category
         *        The category of the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds
         * to the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the
         * check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where
         * the UI shows just summary data.
         * </p>
         * 
         * @param metadata
         *        The column headings for the data returned by the Trusted Advisor check. The order of the headings
         *        corresponds to the order of the data in the <b>Metadata</b> element of the
         *        <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown
         *        in the Excel download, even in those cases where the UI shows just summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Collection<String> metadata);

        /**
         * <p>
         * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds
         * to the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the
         * check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where
         * the UI shows just summary data.
         * </p>
         * 
         * @param metadata
         *        The column headings for the data returned by the Trusted Advisor check. The order of the headings
         *        corresponds to the order of the data in the <b>Metadata</b> element of the
         *        <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown
         *        in the Excel download, even in those cases where the UI shows just summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String... metadata);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String category;

        private List<String> metadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckDescription model) {
            id(model.id);
            name(model.name);
            description(model.description);
            category(model.category);
            metadata(model.metadata);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCategory() {
            return category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final Collection<String> getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(String... metadata) {
            metadata(Arrays.asList(metadata));
            return this;
        }

        public final void setMetadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
        }

        @Override
        public TrustedAdvisorCheckDescription build() {
            return new TrustedAdvisorCheckDescription(this);
        }
    }
}
