/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorResourceDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a resource identified by a Trusted Advisor check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedAdvisorResourceDetail implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorResourceDetail.Builder, TrustedAdvisorResourceDetail> {
    private final String status;

    private final String region;

    private final String resourceId;

    private final Boolean isSuppressed;

    private final List<String> metadata;

    private TrustedAdvisorResourceDetail(BuilderImpl builder) {
        this.status = builder.status;
        this.region = builder.region;
        this.resourceId = builder.resourceId;
        this.isSuppressed = builder.isSuppressed;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The status code for the resource identified in the Trusted Advisor check.
     * </p>
     * 
     * @return The status code for the resource identified in the Trusted Advisor check.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The AWS region in which the identified resource is located.
     * </p>
     * 
     * @return The AWS region in which the identified resource is located.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The unique identifier for the identified resource.
     * </p>
     * 
     * @return The unique identifier for the identified resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Specifies whether the AWS resource was ignored by Trusted Advisor because it was marked as suppressed by the
     * user.
     * </p>
     * 
     * @return Specifies whether the AWS resource was ignored by Trusted Advisor because it was marked as suppressed by
     *         the user.
     */
    public Boolean isSuppressed() {
        return isSuppressed;
    }

    /**
     * <p>
     * Additional information about the identified resource. The exact metadata and its order can be obtained by
     * inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
     * <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel download,
     * even in those cases where the UI shows just summary data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional information about the identified resource. The exact metadata and its order can be obtained by
     *         inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
     *         <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel
     *         download, even in those cases where the UI shows just summary data.
     */
    public List<String> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(isSuppressed());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorResourceDetail)) {
            return false;
        }
        TrustedAdvisorResourceDetail other = (TrustedAdvisorResourceDetail) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(region(), other.region())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(isSuppressed(), other.isSuppressed())
                && Objects.equals(metadata(), other.metadata());
    }

    @Override
    public String toString() {
        return ToString.builder("TrustedAdvisorResourceDetail").add("Status", status()).add("Region", region())
                .add("ResourceId", resourceId()).add("IsSuppressed", isSuppressed()).add("Metadata", metadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "isSuppressed":
            return Optional.ofNullable(clazz.cast(isSuppressed()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorResourceDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorResourceDetail> {
        /**
         * <p>
         * The status code for the resource identified in the Trusted Advisor check.
         * </p>
         * 
         * @param status
         *        The status code for the resource identified in the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The AWS region in which the identified resource is located.
         * </p>
         * 
         * @param region
         *        The AWS region in which the identified resource is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The unique identifier for the identified resource.
         * </p>
         * 
         * @param resourceId
         *        The unique identifier for the identified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Specifies whether the AWS resource was ignored by Trusted Advisor because it was marked as suppressed by the
         * user.
         * </p>
         * 
         * @param isSuppressed
         *        Specifies whether the AWS resource was ignored by Trusted Advisor because it was marked as suppressed
         *        by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSuppressed(Boolean isSuppressed);

        /**
         * <p>
         * Additional information about the identified resource. The exact metadata and its order can be obtained by
         * inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
         * <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel
         * download, even in those cases where the UI shows just summary data.
         * </p>
         * 
         * @param metadata
         *        Additional information about the identified resource. The exact metadata and its order can be obtained
         *        by inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
         *        <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel
         *        download, even in those cases where the UI shows just summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Collection<String> metadata);

        /**
         * <p>
         * Additional information about the identified resource. The exact metadata and its order can be obtained by
         * inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
         * <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel
         * download, even in those cases where the UI shows just summary data.
         * </p>
         * 
         * @param metadata
         *        Additional information about the identified resource. The exact metadata and its order can be obtained
         *        by inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
         *        <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel
         *        download, even in those cases where the UI shows just summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String... metadata);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String region;

        private String resourceId;

        private Boolean isSuppressed;

        private List<String> metadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorResourceDetail model) {
            status(model.status);
            region(model.region);
            resourceId(model.resourceId);
            isSuppressed(model.isSuppressed);
            metadata(model.metadata);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Boolean getIsSuppressed() {
            return isSuppressed;
        }

        @Override
        public final Builder isSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
            return this;
        }

        public final void setIsSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
        }

        public final Collection<String> getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(String... metadata) {
            metadata(Arrays.asList(metadata));
            return this;
        }

        public final void setMetadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
        }

        @Override
        public TrustedAdvisorResourceDetail build() {
            return new TrustedAdvisorResourceDetail(this);
        }
    }
}
