/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.DescribeCasesRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DescribeCasesRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DescribeCasesRequestModelMarshaller {
    private static final MarshallingInfo<List> CASEIDLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caseIdList").isBinary(false).build();

    private static final MarshallingInfo<String> DISPLAYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayId").isBinary(false).build();

    private static final MarshallingInfo<String> AFTERTIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("afterTime").isBinary(false).build();

    private static final MarshallingInfo<String> BEFORETIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("beforeTime").isBinary(false).build();

    private static final MarshallingInfo<Boolean> INCLUDERESOLVEDCASES_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("includeResolvedCases").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxResults").isBinary(false).build();

    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").isBinary(false).build();

    private static final MarshallingInfo<Boolean> INCLUDECOMMUNICATIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("includeCommunications").isBinary(false).build();

    private static final DescribeCasesRequestModelMarshaller INSTANCE = new DescribeCasesRequestModelMarshaller();

    private DescribeCasesRequestModelMarshaller() {
    }

    public static DescribeCasesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DescribeCasesRequest describeCasesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(describeCasesRequest, "describeCasesRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(describeCasesRequest.caseIdList(), CASEIDLIST_BINDING);
            protocolMarshaller.marshall(describeCasesRequest.displayId(), DISPLAYID_BINDING);
            protocolMarshaller.marshall(describeCasesRequest.afterTime(), AFTERTIME_BINDING);
            protocolMarshaller.marshall(describeCasesRequest.beforeTime(), BEFORETIME_BINDING);
            protocolMarshaller.marshall(describeCasesRequest.includeResolvedCases(), INCLUDERESOLVEDCASES_BINDING);
            protocolMarshaller.marshall(describeCasesRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall(describeCasesRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall(describeCasesRequest.language(), LANGUAGE_BINDING);
            protocolMarshaller.marshall(describeCasesRequest.includeCommunications(), INCLUDECOMMUNICATIONS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
