/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.Attachment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttachmentMarshaller {
    private static final MarshallingInfo<String> FILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileName").isBinary(false).build();
    private static final MarshallingInfo<SdkBytes> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("data").isBinary(false).build();
    private static final AttachmentMarshaller INSTANCE = new AttachmentMarshaller();

    private AttachmentMarshaller() {
    }

    public static AttachmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Attachment attachment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)attachment, (String)"attachment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attachment.fileName(), FILENAME_BINDING);
            protocolMarshaller.marshall((Object)attachment.data(), DATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

