/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshTrustedAdvisorCheckRequest extends SupportRequest implements
        ToCopyableBuilder<RefreshTrustedAdvisorCheckRequest.Builder, RefreshTrustedAdvisorCheckRequest> {
    private final String checkId;

    private RefreshTrustedAdvisorCheckRequest(BuilderImpl builder) {
        super(builder);
        this.checkId = builder.checkId;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check to refresh. <b>Note:</b> Specifying the check ID of a check
     * that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check to refresh. <b>Note:</b> Specifying the check ID of a
     *         check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
     */
    public String checkId() {
        return checkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshTrustedAdvisorCheckRequest)) {
            return false;
        }
        RefreshTrustedAdvisorCheckRequest other = (RefreshTrustedAdvisorCheckRequest) obj;
        return Objects.equals(checkId(), other.checkId());
    }

    @Override
    public String toString() {
        return ToString.builder("RefreshTrustedAdvisorCheckRequest").add("CheckId", checkId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkId":
            return Optional.ofNullable(clazz.cast(checkId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SupportRequest.Builder, CopyableBuilder<Builder, RefreshTrustedAdvisorCheckRequest> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check to refresh. <b>Note:</b> Specifying the check ID of a
         * check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check to refresh. <b>Note:</b> Specifying the check ID
         *        of a check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private String checkId;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshTrustedAdvisorCheckRequest model) {
            super(model);
            checkId(model.checkId);
        }

        public final String getCheckId() {
            return checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RefreshTrustedAdvisorCheckRequest build() {
            return new RefreshTrustedAdvisorCheckRequest(this);
        }
    }
}
