/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCostOptimizingSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The estimated cost savings that might be realized if the recommended actions are taken.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedAdvisorCostOptimizingSummary implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorCostOptimizingSummary.Builder, TrustedAdvisorCostOptimizingSummary> {
    private final Double estimatedMonthlySavings;

    private final Double estimatedPercentMonthlySavings;

    private TrustedAdvisorCostOptimizingSummary(BuilderImpl builder) {
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.estimatedPercentMonthlySavings = builder.estimatedPercentMonthlySavings;
    }

    /**
     * <p>
     * The estimated monthly savings that might be realized if the recommended actions are taken.
     * </p>
     * 
     * @return The estimated monthly savings that might be realized if the recommended actions are taken.
     */
    public Double estimatedMonthlySavings() {
        return estimatedMonthlySavings;
    }

    /**
     * <p>
     * The estimated percentage of savings that might be realized if the recommended actions are taken.
     * </p>
     * 
     * @return The estimated percentage of savings that might be realized if the recommended actions are taken.
     */
    public Double estimatedPercentMonthlySavings() {
        return estimatedPercentMonthlySavings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedPercentMonthlySavings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCostOptimizingSummary)) {
            return false;
        }
        TrustedAdvisorCostOptimizingSummary other = (TrustedAdvisorCostOptimizingSummary) obj;
        return Objects.equals(estimatedMonthlySavings(), other.estimatedMonthlySavings())
                && Objects.equals(estimatedPercentMonthlySavings(), other.estimatedPercentMonthlySavings());
    }

    @Override
    public String toString() {
        return ToString.builder("TrustedAdvisorCostOptimizingSummary").add("EstimatedMonthlySavings", estimatedMonthlySavings())
                .add("EstimatedPercentMonthlySavings", estimatedPercentMonthlySavings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "estimatedMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavings()));
        case "estimatedPercentMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedPercentMonthlySavings()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCostOptimizingSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorCostOptimizingSummary> {
        /**
         * <p>
         * The estimated monthly savings that might be realized if the recommended actions are taken.
         * </p>
         * 
         * @param estimatedMonthlySavings
         *        The estimated monthly savings that might be realized if the recommended actions are taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavings(Double estimatedMonthlySavings);

        /**
         * <p>
         * The estimated percentage of savings that might be realized if the recommended actions are taken.
         * </p>
         * 
         * @param estimatedPercentMonthlySavings
         *        The estimated percentage of savings that might be realized if the recommended actions are taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings);
    }

    static final class BuilderImpl implements Builder {
        private Double estimatedMonthlySavings;

        private Double estimatedPercentMonthlySavings;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCostOptimizingSummary model) {
            estimatedMonthlySavings(model.estimatedMonthlySavings);
            estimatedPercentMonthlySavings(model.estimatedPercentMonthlySavings);
        }

        public final Double getEstimatedMonthlySavings() {
            return estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final void setEstimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        public final Double getEstimatedPercentMonthlySavings() {
            return estimatedPercentMonthlySavings;
        }

        @Override
        public final Builder estimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings) {
            this.estimatedPercentMonthlySavings = estimatedPercentMonthlySavings;
            return this;
        }

        public final void setEstimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings) {
            this.estimatedPercentMonthlySavings = estimatedPercentMonthlySavings;
        }

        @Override
        public TrustedAdvisorCostOptimizingSummary build() {
            return new TrustedAdvisorCostOptimizingSummary(this);
        }
    }
}
