/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AddCommunicationToCaseRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AddCommunicationToCaseRequestModelMarshaller {
    private static final MarshallingInfo<String> CASEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caseId").isBinary(false).build();

    private static final MarshallingInfo<String> COMMUNICATIONBODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("communicationBody").isBinary(false).build();

    private static final MarshallingInfo<List> CCEMAILADDRESSES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ccEmailAddresses").isBinary(false).build();

    private static final MarshallingInfo<String> ATTACHMENTSETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachmentSetId").isBinary(false).build();

    private static final AddCommunicationToCaseRequestModelMarshaller INSTANCE = new AddCommunicationToCaseRequestModelMarshaller();

    private AddCommunicationToCaseRequestModelMarshaller() {
    }

    public static AddCommunicationToCaseRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AddCommunicationToCaseRequest addCommunicationToCaseRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(addCommunicationToCaseRequest, "addCommunicationToCaseRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(addCommunicationToCaseRequest.caseId(), CASEID_BINDING);
            protocolMarshaller.marshall(addCommunicationToCaseRequest.communicationBody(), COMMUNICATIONBODY_BINDING);
            protocolMarshaller.marshall(addCommunicationToCaseRequest.ccEmailAddresses(), CCEMAILADDRESSES_BINDING);
            protocolMarshaller.marshall(addCommunicationToCaseRequest.attachmentSetId(), ATTACHMENTSETID_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
