/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.support.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeAttachmentResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeAttachmentResponseUnmarshaller implements Unmarshaller<DescribeAttachmentResponse, JsonUnmarshallerContext> {

    public DescribeAttachmentResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeAttachmentResponse.Builder describeAttachmentResponseBuilder = DescribeAttachmentResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeAttachmentResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("attachment", targetDepth)) {
                    context.nextToken();
                    describeAttachmentResponseBuilder.attachment(AttachmentUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeAttachmentResponseBuilder.build();
    }

    private static final DescribeAttachmentResponseUnmarshaller INSTANCE = new DescribeAttachmentResponseUnmarshaller();

    public static DescribeAttachmentResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
