/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DescribeCommunicationsRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DescribeCommunicationsRequestModelMarshaller {
    private static final MarshallingInfo<String> CASEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caseId").isBinary(false).build();

    private static final MarshallingInfo<String> BEFORETIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("beforeTime").isBinary(false).build();

    private static final MarshallingInfo<String> AFTERTIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("afterTime").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxResults").isBinary(false).build();

    private static final DescribeCommunicationsRequestModelMarshaller INSTANCE = new DescribeCommunicationsRequestModelMarshaller();

    private DescribeCommunicationsRequestModelMarshaller() {
    }

    public static DescribeCommunicationsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DescribeCommunicationsRequest describeCommunicationsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(describeCommunicationsRequest, "describeCommunicationsRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(describeCommunicationsRequest.caseId(), CASEID_BINDING);
            protocolMarshaller.marshall(describeCommunicationsRequest.beforeTime(), BEFORETIME_BINDING);
            protocolMarshaller.marshall(describeCommunicationsRequest.afterTime(), AFTERTIME_BINDING);
            protocolMarshaller.marshall(describeCommunicationsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall(describeCommunicationsRequest.maxResults(), MAXRESULTS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
