/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * To be written.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddCommunicationToCaseRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AddCommunicationToCaseRequest.Builder, AddCommunicationToCaseRequest> {
    private final String caseId;

    private final String communicationBody;

    private final List<String> ccEmailAddresses;

    private final String attachmentSetId;

    private AddCommunicationToCaseRequest(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.communicationBody = builder.communicationBody;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.attachmentSetId = builder.attachmentSetId;
    }

    /**
     * <p>
     * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
     * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     * </p>
     * 
     * @return The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
     *         formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     */
    public String caseId() {
        return caseId;
    }

    /**
     * <p>
     * The body of an email communication to add to the support case.
     * </p>
     * 
     * @return The body of an email communication to add to the support case.
     */
    public String communicationBody() {
        return communicationBody;
    }

    /**
     * <p>
     * The email addresses in the CC line of an email to be added to the support case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The email addresses in the CC line of an email to be added to the support case.
     */
    public List<String> ccEmailAddresses() {
        return ccEmailAddresses;
    }

    /**
     * <p>
     * The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling
     * <a>AddAttachmentsToSet</a>
     * </p>
     * 
     * @return The ID of a set of one or more attachments for the communication to add to the case. Create the set by
     *         calling <a>AddAttachmentsToSet</a>
     */
    public String attachmentSetId() {
        return attachmentSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((caseId() == null) ? 0 : caseId().hashCode());
        hashCode = 31 * hashCode + ((communicationBody() == null) ? 0 : communicationBody().hashCode());
        hashCode = 31 * hashCode + ((ccEmailAddresses() == null) ? 0 : ccEmailAddresses().hashCode());
        hashCode = 31 * hashCode + ((attachmentSetId() == null) ? 0 : attachmentSetId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCommunicationToCaseRequest)) {
            return false;
        }
        AddCommunicationToCaseRequest other = (AddCommunicationToCaseRequest) obj;
        if (other.caseId() == null ^ this.caseId() == null) {
            return false;
        }
        if (other.caseId() != null && !other.caseId().equals(this.caseId())) {
            return false;
        }
        if (other.communicationBody() == null ^ this.communicationBody() == null) {
            return false;
        }
        if (other.communicationBody() != null && !other.communicationBody().equals(this.communicationBody())) {
            return false;
        }
        if (other.ccEmailAddresses() == null ^ this.ccEmailAddresses() == null) {
            return false;
        }
        if (other.ccEmailAddresses() != null && !other.ccEmailAddresses().equals(this.ccEmailAddresses())) {
            return false;
        }
        if (other.attachmentSetId() == null ^ this.attachmentSetId() == null) {
            return false;
        }
        if (other.attachmentSetId() != null && !other.attachmentSetId().equals(this.attachmentSetId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (caseId() != null) {
            sb.append("CaseId: ").append(caseId()).append(",");
        }
        if (communicationBody() != null) {
            sb.append("CommunicationBody: ").append(communicationBody()).append(",");
        }
        if (ccEmailAddresses() != null) {
            sb.append("CcEmailAddresses: ").append(ccEmailAddresses()).append(",");
        }
        if (attachmentSetId() != null) {
            sb.append("AttachmentSetId: ").append(attachmentSetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AddCommunicationToCaseRequest> {
        /**
         * <p>
         * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
         * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * </p>
         * 
         * @param caseId
         *        The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
         *        formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * The body of an email communication to add to the support case.
         * </p>
         * 
         * @param communicationBody
         *        The body of an email communication to add to the support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationBody(String communicationBody);

        /**
         * <p>
         * The email addresses in the CC line of an email to be added to the support case.
         * </p>
         * 
         * @param ccEmailAddresses
         *        The email addresses in the CC line of an email to be added to the support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(Collection<String> ccEmailAddresses);

        /**
         * <p>
         * The email addresses in the CC line of an email to be added to the support case.
         * </p>
         * 
         * @param ccEmailAddresses
         *        The email addresses in the CC line of an email to be added to the support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(String... ccEmailAddresses);

        /**
         * <p>
         * The ID of a set of one or more attachments for the communication to add to the case. Create the set by
         * calling <a>AddAttachmentsToSet</a>
         * </p>
         * 
         * @param attachmentSetId
         *        The ID of a set of one or more attachments for the communication to add to the case. Create the set by
         *        calling <a>AddAttachmentsToSet</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSetId(String attachmentSetId);
    }

    private static final class BuilderImpl implements Builder {
        private String caseId;

        private String communicationBody;

        private List<String> ccEmailAddresses;

        private String attachmentSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddCommunicationToCaseRequest model) {
            setCaseId(model.caseId);
            setCommunicationBody(model.communicationBody);
            setCcEmailAddresses(model.ccEmailAddresses);
            setAttachmentSetId(model.attachmentSetId);
        }

        public final String getCaseId() {
            return caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getCommunicationBody() {
            return communicationBody;
        }

        @Override
        public final Builder communicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
            return this;
        }

        public final void setCommunicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
        }

        public final Collection<String> getCcEmailAddresses() {
            return ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String... ccEmailAddresses) {
            ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        @SafeVarargs
        public final void setCcEmailAddresses(String... ccEmailAddresses) {
            ccEmailAddresses(Arrays.asList(ccEmailAddresses));
        }

        public final String getAttachmentSetId() {
            return attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        @Override
        public AddCommunicationToCaseRequest build() {
            return new AddCommunicationToCaseRequest(this);
        }
    }
}
