/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description and metadata for a Trusted Advisor check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrustedAdvisorCheckDescription implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorCheckDescription.Builder, TrustedAdvisorCheckDescription> {
    private final String id;

    private final String name;

    private final String description;

    private final String category;

    private final List<String> metadata;

    private TrustedAdvisorCheckDescription(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.category = builder.category;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The display name for the Trusted Advisor check.
     * </p>
     * 
     * @return The display name for the Trusted Advisor check.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the Trusted Advisor check, which includes the alert criteria and recommended actions (contains
     * HTML markup).
     * </p>
     * 
     * @return The description of the Trusted Advisor check, which includes the alert criteria and recommended actions
     *         (contains HTML markup).
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The category of the Trusted Advisor check.
     * </p>
     * 
     * @return The category of the Trusted Advisor check.
     */
    public String category() {
        return category;
    }

    /**
     * <p>
     * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to
     * the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the check.
     * <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows
     * just summary data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The column headings for the data returned by the Trusted Advisor check. The order of the headings
     *         corresponds to the order of the data in the <b>Metadata</b> element of the
     *         <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown in
     *         the Excel download, even in those cases where the UI shows just summary data.
     */
    public List<String> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((category() == null) ? 0 : category().hashCode());
        hashCode = 31 * hashCode + ((metadata() == null) ? 0 : metadata().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckDescription)) {
            return false;
        }
        TrustedAdvisorCheckDescription other = (TrustedAdvisorCheckDescription) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.category() == null ^ this.category() == null) {
            return false;
        }
        if (other.category() != null && !other.category().equals(this.category())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (category() != null) {
            sb.append("Category: ").append(category()).append(",");
        }
        if (metadata() != null) {
            sb.append("Metadata: ").append(metadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorCheckDescription> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param id
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The display name for the Trusted Advisor check.
         * </p>
         * 
         * @param name
         *        The display name for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the Trusted Advisor check, which includes the alert criteria and recommended actions
         * (contains HTML markup).
         * </p>
         * 
         * @param description
         *        The description of the Trusted Advisor check, which includes the alert criteria and recommended
         *        actions (contains HTML markup).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The category of the Trusted Advisor check.
         * </p>
         * 
         * @param category
         *        The category of the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds
         * to the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the
         * check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where
         * the UI shows just summary data.
         * </p>
         * 
         * @param metadata
         *        The column headings for the data returned by the Trusted Advisor check. The order of the headings
         *        corresponds to the order of the data in the <b>Metadata</b> element of the
         *        <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown
         *        in the Excel download, even in those cases where the UI shows just summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Collection<String> metadata);

        /**
         * <p>
         * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds
         * to the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the
         * check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where
         * the UI shows just summary data.
         * </p>
         * 
         * @param metadata
         *        The column headings for the data returned by the Trusted Advisor check. The order of the headings
         *        corresponds to the order of the data in the <b>Metadata</b> element of the
         *        <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown
         *        in the Excel download, even in those cases where the UI shows just summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String... metadata);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String category;

        private List<String> metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckDescription model) {
            setId(model.id);
            setName(model.name);
            setDescription(model.description);
            setCategory(model.category);
            setMetadata(model.metadata);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCategory() {
            return category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final Collection<String> getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(String... metadata) {
            metadata(Arrays.asList(metadata));
            return this;
        }

        public final void setMetadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
        }

        @SafeVarargs
        public final void setMetadata(String... metadata) {
            metadata(Arrays.asList(metadata));
        }

        @Override
        public TrustedAdvisorCheckDescription build() {
            return new TrustedAdvisorCheckDescription(this);
        }
    }
}
