/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCostOptimizingSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The estimated cost savings that might be realized if the recommended actions are taken.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrustedAdvisorCostOptimizingSummary implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorCostOptimizingSummary.Builder, TrustedAdvisorCostOptimizingSummary> {
    private final Double estimatedMonthlySavings;

    private final Double estimatedPercentMonthlySavings;

    private TrustedAdvisorCostOptimizingSummary(BuilderImpl builder) {
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.estimatedPercentMonthlySavings = builder.estimatedPercentMonthlySavings;
    }

    /**
     * <p>
     * The estimated monthly savings that might be realized if the recommended actions are taken.
     * </p>
     * 
     * @return The estimated monthly savings that might be realized if the recommended actions are taken.
     */
    public Double estimatedMonthlySavings() {
        return estimatedMonthlySavings;
    }

    /**
     * <p>
     * The estimated percentage of savings that might be realized if the recommended actions are taken.
     * </p>
     * 
     * @return The estimated percentage of savings that might be realized if the recommended actions are taken.
     */
    public Double estimatedPercentMonthlySavings() {
        return estimatedPercentMonthlySavings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((estimatedMonthlySavings() == null) ? 0 : estimatedMonthlySavings().hashCode());
        hashCode = 31 * hashCode + ((estimatedPercentMonthlySavings() == null) ? 0 : estimatedPercentMonthlySavings().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCostOptimizingSummary)) {
            return false;
        }
        TrustedAdvisorCostOptimizingSummary other = (TrustedAdvisorCostOptimizingSummary) obj;
        if (other.estimatedMonthlySavings() == null ^ this.estimatedMonthlySavings() == null) {
            return false;
        }
        if (other.estimatedMonthlySavings() != null && !other.estimatedMonthlySavings().equals(this.estimatedMonthlySavings())) {
            return false;
        }
        if (other.estimatedPercentMonthlySavings() == null ^ this.estimatedPercentMonthlySavings() == null) {
            return false;
        }
        if (other.estimatedPercentMonthlySavings() != null
                && !other.estimatedPercentMonthlySavings().equals(this.estimatedPercentMonthlySavings())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (estimatedMonthlySavings() != null) {
            sb.append("EstimatedMonthlySavings: ").append(estimatedMonthlySavings()).append(",");
        }
        if (estimatedPercentMonthlySavings() != null) {
            sb.append("EstimatedPercentMonthlySavings: ").append(estimatedPercentMonthlySavings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCostOptimizingSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorCostOptimizingSummary> {
        /**
         * <p>
         * The estimated monthly savings that might be realized if the recommended actions are taken.
         * </p>
         * 
         * @param estimatedMonthlySavings
         *        The estimated monthly savings that might be realized if the recommended actions are taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavings(Double estimatedMonthlySavings);

        /**
         * <p>
         * The estimated percentage of savings that might be realized if the recommended actions are taken.
         * </p>
         * 
         * @param estimatedPercentMonthlySavings
         *        The estimated percentage of savings that might be realized if the recommended actions are taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings);
    }

    private static final class BuilderImpl implements Builder {
        private Double estimatedMonthlySavings;

        private Double estimatedPercentMonthlySavings;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCostOptimizingSummary model) {
            setEstimatedMonthlySavings(model.estimatedMonthlySavings);
            setEstimatedPercentMonthlySavings(model.estimatedPercentMonthlySavings);
        }

        public final Double getEstimatedMonthlySavings() {
            return estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final void setEstimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        public final Double getEstimatedPercentMonthlySavings() {
            return estimatedPercentMonthlySavings;
        }

        @Override
        public final Builder estimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings) {
            this.estimatedPercentMonthlySavings = estimatedPercentMonthlySavings;
            return this;
        }

        public final void setEstimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings) {
            this.estimatedPercentMonthlySavings = estimatedPercentMonthlySavings;
        }

        @Override
        public TrustedAdvisorCostOptimizingSummary build() {
            return new TrustedAdvisorCostOptimizingSummary(this);
        }
    }
}
