/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.support.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CaseDetails JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CaseDetailsUnmarshaller implements Unmarshaller<CaseDetails, JsonUnmarshallerContext> {

    public CaseDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        CaseDetails.Builder caseDetailsBuilder = CaseDetails.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("caseId", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.caseId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("displayId", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.displayId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("subject", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.subject(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("serviceCode", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.serviceCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("categoryCode", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.categoryCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("severityCode", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.severityCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("submittedBy", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.submittedBy(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("timeCreated", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.timeCreated(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("recentCommunications", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.recentCommunications(RecentCaseCommunicationsUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("ccEmailAddresses", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.ccEmailAddresses(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("language", targetDepth)) {
                    context.nextToken();
                    caseDetailsBuilder.language(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return caseDetailsBuilder.build();
    }

    private static CaseDetailsUnmarshaller INSTANCE;

    public static CaseDetailsUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CaseDetailsUnmarshaller();
        return INSTANCE;
    }
}
