/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.support.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * TrustedAdvisorCheckSummary JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TrustedAdvisorCheckSummaryUnmarshaller implements Unmarshaller<TrustedAdvisorCheckSummary, JsonUnmarshallerContext> {

    public TrustedAdvisorCheckSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        TrustedAdvisorCheckSummary.Builder trustedAdvisorCheckSummaryBuilder = TrustedAdvisorCheckSummary.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("checkId", targetDepth)) {
                    context.nextToken();
                    trustedAdvisorCheckSummaryBuilder.checkId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("timestamp", targetDepth)) {
                    context.nextToken();
                    trustedAdvisorCheckSummaryBuilder.timestamp(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    trustedAdvisorCheckSummaryBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("hasFlaggedResources", targetDepth)) {
                    context.nextToken();
                    trustedAdvisorCheckSummaryBuilder.hasFlaggedResources(context.getUnmarshaller(Boolean.class).unmarshall(
                            context));
                }
                if (context.testExpression("resourcesSummary", targetDepth)) {
                    context.nextToken();
                    trustedAdvisorCheckSummaryBuilder.resourcesSummary(TrustedAdvisorResourcesSummaryUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("categorySpecificSummary", targetDepth)) {
                    context.nextToken();
                    trustedAdvisorCheckSummaryBuilder.categorySpecificSummary(TrustedAdvisorCategorySpecificSummaryUnmarshaller
                            .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return trustedAdvisorCheckSummaryBuilder.build();
    }

    private static TrustedAdvisorCheckSummaryUnmarshaller INSTANCE;

    public static TrustedAdvisorCheckSummaryUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new TrustedAdvisorCheckSummaryUnmarshaller();
        return INSTANCE;
    }
}
