/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.CcEmailAddressListCopier;
import software.amazon.awssdk.services.support.model.RecentCaseCommunications;
import software.amazon.awssdk.services.support.transform.CaseDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CaseDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, CaseDetails> {
    private final String caseId;
    private final String displayId;
    private final String subject;
    private final String status;
    private final String serviceCode;
    private final String categoryCode;
    private final String severityCode;
    private final String submittedBy;
    private final String timeCreated;
    private final RecentCaseCommunications recentCommunications;
    private final List<String> ccEmailAddresses;
    private final String language;

    private CaseDetails(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.displayId = builder.displayId;
        this.subject = builder.subject;
        this.status = builder.status;
        this.serviceCode = builder.serviceCode;
        this.categoryCode = builder.categoryCode;
        this.severityCode = builder.severityCode;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.recentCommunications = builder.recentCommunications;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.language = builder.language;
    }

    public String caseId() {
        return this.caseId;
    }

    public String displayId() {
        return this.displayId;
    }

    public String subject() {
        return this.subject;
    }

    public String status() {
        return this.status;
    }

    public String serviceCode() {
        return this.serviceCode;
    }

    public String categoryCode() {
        return this.categoryCode;
    }

    public String severityCode() {
        return this.severityCode;
    }

    public String submittedBy() {
        return this.submittedBy;
    }

    public String timeCreated() {
        return this.timeCreated;
    }

    public RecentCaseCommunications recentCommunications() {
        return this.recentCommunications;
    }

    public List<String> ccEmailAddresses() {
        return this.ccEmailAddresses;
    }

    public String language() {
        return this.language;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.caseId() == null ? 0 : this.caseId().hashCode());
        hashCode = 31 * hashCode + (this.displayId() == null ? 0 : this.displayId().hashCode());
        hashCode = 31 * hashCode + (this.subject() == null ? 0 : this.subject().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.serviceCode() == null ? 0 : this.serviceCode().hashCode());
        hashCode = 31 * hashCode + (this.categoryCode() == null ? 0 : this.categoryCode().hashCode());
        hashCode = 31 * hashCode + (this.severityCode() == null ? 0 : this.severityCode().hashCode());
        hashCode = 31 * hashCode + (this.submittedBy() == null ? 0 : this.submittedBy().hashCode());
        hashCode = 31 * hashCode + (this.timeCreated() == null ? 0 : this.timeCreated().hashCode());
        hashCode = 31 * hashCode + (this.recentCommunications() == null ? 0 : this.recentCommunications().hashCode());
        hashCode = 31 * hashCode + (this.ccEmailAddresses() == null ? 0 : this.ccEmailAddresses().hashCode());
        hashCode = 31 * hashCode + (this.language() == null ? 0 : this.language().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseDetails)) {
            return false;
        }
        CaseDetails other = (CaseDetails)obj;
        if (other.caseId() == null ^ this.caseId() == null) {
            return false;
        }
        if (other.caseId() != null && !other.caseId().equals(this.caseId())) {
            return false;
        }
        if (other.displayId() == null ^ this.displayId() == null) {
            return false;
        }
        if (other.displayId() != null && !other.displayId().equals(this.displayId())) {
            return false;
        }
        if (other.subject() == null ^ this.subject() == null) {
            return false;
        }
        if (other.subject() != null && !other.subject().equals(this.subject())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.serviceCode() == null ^ this.serviceCode() == null) {
            return false;
        }
        if (other.serviceCode() != null && !other.serviceCode().equals(this.serviceCode())) {
            return false;
        }
        if (other.categoryCode() == null ^ this.categoryCode() == null) {
            return false;
        }
        if (other.categoryCode() != null && !other.categoryCode().equals(this.categoryCode())) {
            return false;
        }
        if (other.severityCode() == null ^ this.severityCode() == null) {
            return false;
        }
        if (other.severityCode() != null && !other.severityCode().equals(this.severityCode())) {
            return false;
        }
        if (other.submittedBy() == null ^ this.submittedBy() == null) {
            return false;
        }
        if (other.submittedBy() != null && !other.submittedBy().equals(this.submittedBy())) {
            return false;
        }
        if (other.timeCreated() == null ^ this.timeCreated() == null) {
            return false;
        }
        if (other.timeCreated() != null && !other.timeCreated().equals(this.timeCreated())) {
            return false;
        }
        if (other.recentCommunications() == null ^ this.recentCommunications() == null) {
            return false;
        }
        if (other.recentCommunications() != null && !other.recentCommunications().equals(this.recentCommunications())) {
            return false;
        }
        if (other.ccEmailAddresses() == null ^ this.ccEmailAddresses() == null) {
            return false;
        }
        if (other.ccEmailAddresses() != null && !other.ccEmailAddresses().equals(this.ccEmailAddresses())) {
            return false;
        }
        if (other.language() == null ^ this.language() == null) {
            return false;
        }
        return other.language() == null || other.language().equals(this.language());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caseId() != null) {
            sb.append("CaseId: ").append(this.caseId()).append(",");
        }
        if (this.displayId() != null) {
            sb.append("DisplayId: ").append(this.displayId()).append(",");
        }
        if (this.subject() != null) {
            sb.append("Subject: ").append(this.subject()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.serviceCode() != null) {
            sb.append("ServiceCode: ").append(this.serviceCode()).append(",");
        }
        if (this.categoryCode() != null) {
            sb.append("CategoryCode: ").append(this.categoryCode()).append(",");
        }
        if (this.severityCode() != null) {
            sb.append("SeverityCode: ").append(this.severityCode()).append(",");
        }
        if (this.submittedBy() != null) {
            sb.append("SubmittedBy: ").append(this.submittedBy()).append(",");
        }
        if (this.timeCreated() != null) {
            sb.append("TimeCreated: ").append(this.timeCreated()).append(",");
        }
        if (this.recentCommunications() != null) {
            sb.append("RecentCommunications: ").append(this.recentCommunications()).append(",");
        }
        if (this.ccEmailAddresses() != null) {
            sb.append("CcEmailAddresses: ").append(this.ccEmailAddresses()).append(",");
        }
        if (this.language() != null) {
            sb.append("Language: ").append(this.language()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CaseDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String caseId;
        private String displayId;
        private String subject;
        private String status;
        private String serviceCode;
        private String categoryCode;
        private String severityCode;
        private String submittedBy;
        private String timeCreated;
        private RecentCaseCommunications recentCommunications;
        private List<String> ccEmailAddresses;
        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseDetails model) {
            this.setCaseId(model.caseId);
            this.setDisplayId(model.displayId);
            this.setSubject(model.subject);
            this.setStatus(model.status);
            this.setServiceCode(model.serviceCode);
            this.setCategoryCode(model.categoryCode);
            this.setSeverityCode(model.severityCode);
            this.setSubmittedBy(model.submittedBy);
            this.setTimeCreated(model.timeCreated);
            this.setRecentCommunications(model.recentCommunications);
            this.setCcEmailAddresses(model.ccEmailAddresses);
            this.setLanguage(model.language);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getDisplayId() {
            return this.displayId;
        }

        @Override
        public final Builder displayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public final void setDisplayId(String displayId) {
            this.displayId = displayId;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getCategoryCode() {
            return this.categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        public final String getSeverityCode() {
            return this.severityCode;
        }

        @Override
        public final Builder severityCode(String severityCode) {
            this.severityCode = severityCode;
            return this;
        }

        public final void setSeverityCode(String severityCode) {
            this.severityCode = severityCode;
        }

        public final String getSubmittedBy() {
            return this.submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        public final String getTimeCreated() {
            return this.timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final RecentCaseCommunications getRecentCommunications() {
            return this.recentCommunications;
        }

        @Override
        public final Builder recentCommunications(RecentCaseCommunications recentCommunications) {
            this.recentCommunications = recentCommunications;
            return this;
        }

        public final void setRecentCommunications(RecentCaseCommunications recentCommunications) {
            this.recentCommunications = recentCommunications;
        }

        public final Collection<String> getCcEmailAddresses() {
            return this.ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String ... ccEmailAddresses) {
            this.ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        @SafeVarargs
        public final void setCcEmailAddresses(String ... ccEmailAddresses) {
            this.ccEmailAddresses(Arrays.asList(ccEmailAddresses));
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public CaseDetails build() {
            return new CaseDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CaseDetails> {
        public Builder caseId(String var1);

        public Builder displayId(String var1);

        public Builder subject(String var1);

        public Builder status(String var1);

        public Builder serviceCode(String var1);

        public Builder categoryCode(String var1);

        public Builder severityCode(String var1);

        public Builder submittedBy(String var1);

        public Builder timeCreated(String var1);

        public Builder recentCommunications(RecentCaseCommunications var1);

        public Builder ccEmailAddresses(Collection<String> var1);

        public Builder ccEmailAddresses(String ... var1);

        public Builder language(String var1);
    }
}

