/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTrustedAdvisorCheckRefreshStatusesRequest extends AmazonWebServiceRequest
        implements
        ToCopyableBuilder<DescribeTrustedAdvisorCheckRefreshStatusesRequest.Builder, DescribeTrustedAdvisorCheckRefreshStatusesRequest> {
    private final List<String> checkIds;

    private DescribeTrustedAdvisorCheckRefreshStatusesRequest(BuilderImpl builder) {
        this.checkIds = builder.checkIds;
    }

    /**
     * <p>
     * The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a check that
     * is automatically refreshed causes an <code>InvalidParameterValue</code> error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a
     *         check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
     */
    public List<String> checkIds() {
        return checkIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((checkIds() == null) ? 0 : checkIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckRefreshStatusesRequest)) {
            return false;
        }
        DescribeTrustedAdvisorCheckRefreshStatusesRequest other = (DescribeTrustedAdvisorCheckRefreshStatusesRequest) obj;
        if (other.checkIds() == null ^ this.checkIds() == null) {
            return false;
        }
        if (other.checkIds() != null && !other.checkIds().equals(this.checkIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (checkIds() != null) {
            sb.append("CheckIds: ").append(checkIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTrustedAdvisorCheckRefreshStatusesRequest> {
        /**
         * <p>
         * The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a check
         * that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param checkIds
         *        The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a
         *        check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIds(Collection<String> checkIds);

        /**
         * <p>
         * The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a check
         * that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param checkIds
         *        The IDs of the Trusted Advisor checks to get the status of. <b>Note:</b> Specifying the check ID of a
         *        check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIds(String... checkIds);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> checkIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckRefreshStatusesRequest model) {
            setCheckIds(model.checkIds);
        }

        public final Collection<String> getCheckIds() {
            return checkIds;
        }

        @Override
        public final Builder checkIds(Collection<String> checkIds) {
            this.checkIds = StringListCopier.copy(checkIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIds(String... checkIds) {
            checkIds(Arrays.asList(checkIds));
            return this;
        }

        public final void setCheckIds(Collection<String> checkIds) {
            this.checkIds = StringListCopier.copy(checkIds);
        }

        @Override
        public DescribeTrustedAdvisorCheckRefreshStatusesRequest build() {
            return new DescribeTrustedAdvisorCheckRefreshStatusesRequest(this);
        }
    }
}
