/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckRefreshStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The refresh status of a Trusted Advisor check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrustedAdvisorCheckRefreshStatus implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorCheckRefreshStatus.Builder, TrustedAdvisorCheckRefreshStatus> {
    private final String checkId;

    private final String status;

    private final Long millisUntilNextRefreshable;

    private TrustedAdvisorCheckRefreshStatus(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.status = builder.status;
        this.millisUntilNextRefreshable = builder.millisUntilNextRefreshable;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The status of the Trusted Advisor check for which a refresh has been requested: "none", "enqueued", "processing",
     * "success", or "abandoned".
     * </p>
     * 
     * @return The status of the Trusted Advisor check for which a refresh has been requested: "none", "enqueued",
     *         "processing", "success", or "abandoned".
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
     * </p>
     * 
     * @return The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
     */
    public Long millisUntilNextRefreshable() {
        return millisUntilNextRefreshable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((checkId() == null) ? 0 : checkId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((millisUntilNextRefreshable() == null) ? 0 : millisUntilNextRefreshable().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckRefreshStatus)) {
            return false;
        }
        TrustedAdvisorCheckRefreshStatus other = (TrustedAdvisorCheckRefreshStatus) obj;
        if (other.checkId() == null ^ this.checkId() == null) {
            return false;
        }
        if (other.checkId() != null && !other.checkId().equals(this.checkId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.millisUntilNextRefreshable() == null ^ this.millisUntilNextRefreshable() == null) {
            return false;
        }
        if (other.millisUntilNextRefreshable() != null
                && !other.millisUntilNextRefreshable().equals(this.millisUntilNextRefreshable())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (checkId() != null) {
            sb.append("CheckId: ").append(checkId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (millisUntilNextRefreshable() != null) {
            sb.append("MillisUntilNextRefreshable: ").append(millisUntilNextRefreshable()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckRefreshStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorCheckRefreshStatus> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The status of the Trusted Advisor check for which a refresh has been requested: "none", "enqueued",
         * "processing", "success", or "abandoned".
         * </p>
         * 
         * @param status
         *        The status of the Trusted Advisor check for which a refresh has been requested: "none", "enqueued",
         *        "processing", "success", or "abandoned".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
         * </p>
         * 
         * @param millisUntilNextRefreshable
         *        The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder millisUntilNextRefreshable(Long millisUntilNextRefreshable);
    }

    private static final class BuilderImpl implements Builder {
        private String checkId;

        private String status;

        private Long millisUntilNextRefreshable;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckRefreshStatus model) {
            setCheckId(model.checkId);
            setStatus(model.status);
            setMillisUntilNextRefreshable(model.millisUntilNextRefreshable);
        }

        public final String getCheckId() {
            return checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getMillisUntilNextRefreshable() {
            return millisUntilNextRefreshable;
        }

        @Override
        public final Builder millisUntilNextRefreshable(Long millisUntilNextRefreshable) {
            this.millisUntilNextRefreshable = millisUntilNextRefreshable;
            return this;
        }

        public final void setMillisUntilNextRefreshable(Long millisUntilNextRefreshable) {
            this.millisUntilNextRefreshable = millisUntilNextRefreshable;
        }

        @Override
        public TrustedAdvisorCheckRefreshStatus build() {
            return new TrustedAdvisorCheckRefreshStatus(this);
        }
    }
}
