/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.nio.ByteBuffer;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.support.transform.AttachmentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attachment to a case communication. The attachment consists of the file name and the content of the file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Attachment implements StructuredPojo, ToCopyableBuilder<Attachment.Builder, Attachment> {
    private final String fileName;

    private final ByteBuffer data;

    private Attachment(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.data = builder.data;
    }

    /**
     * <p>
     * The name of the attachment file.
     * </p>
     * 
     * @return The name of the attachment file.
     */
    public String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The content of the attachment file.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The content of the attachment file.
     */
    public ByteBuffer data() {
        return data == null ? null : data.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fileName() == null) ? 0 : fileName().hashCode());
        hashCode = 31 * hashCode + ((data() == null) ? 0 : data().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment) obj;
        if (other.fileName() == null ^ this.fileName() == null) {
            return false;
        }
        if (other.fileName() != null && !other.fileName().equals(this.fileName())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fileName() != null) {
            sb.append("FileName: ").append(fileName()).append(",");
        }
        if (data() != null) {
            sb.append("Data: ").append(data()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileName":
            return Optional.of(clazz.cast(fileName()));
        case "data":
            return Optional.of(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Attachment> {
        /**
         * <p>
         * The name of the attachment file.
         * </p>
         * 
         * @param fileName
         *        The name of the attachment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The content of the attachment file.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param data
         *        The content of the attachment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(ByteBuffer data);
    }

    static final class BuilderImpl implements Builder {
        private String fileName;

        private ByteBuffer data;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            fileName(model.fileName);
            data(model.data);
        }

        public final String getFileName() {
            return fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public final ByteBuffer getData() {
            return data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy(data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy(data);
        }

        @Override
        public Attachment build() {
            return new Attachment(this);
        }
    }
}
