/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCaseRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateCaseRequest.Builder, CreateCaseRequest> {
    private final String subject;

    private final String serviceCode;

    private final String severityCode;

    private final String categoryCode;

    private final String communicationBody;

    private final List<String> ccEmailAddresses;

    private final String language;

    private final String issueType;

    private final String attachmentSetId;

    private CreateCaseRequest(BuilderImpl builder) {
        this.subject = builder.subject;
        this.serviceCode = builder.serviceCode;
        this.severityCode = builder.severityCode;
        this.categoryCode = builder.categoryCode;
        this.communicationBody = builder.communicationBody;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.language = builder.language;
        this.issueType = builder.issueType;
        this.attachmentSetId = builder.attachmentSetId;
    }

    /**
     * <p>
     * The title of the AWS Support case.
     * </p>
     * 
     * @return The title of the AWS Support case.
     */
    public String subject() {
        return subject;
    }

    /**
     * <p>
     * The code for the AWS service returned by the call to <a>DescribeServices</a>.
     * </p>
     * 
     * @return The code for the AWS service returned by the call to <a>DescribeServices</a>.
     */
    public String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
     * </p>
     * <note>
     * <p>
     * The availability of severity levels depends on each customer's support subscription. In other words, your
     * subscription may not necessarily require the urgent level of response time.
     * </p>
     * </note>
     * 
     * @return The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.</p> <note>
     *         <p>
     *         The availability of severity levels depends on each customer's support subscription. In other words, your
     *         subscription may not necessarily require the urgent level of response time.
     *         </p>
     */
    public String severityCode() {
        return severityCode;
    }

    /**
     * <p>
     * The category of problem for the AWS Support case.
     * </p>
     * 
     * @return The category of problem for the AWS Support case.
     */
    public String categoryCode() {
        return categoryCode;
    }

    /**
     * <p>
     * The communication body text when you create an AWS Support case by calling <a>CreateCase</a>.
     * </p>
     * 
     * @return The communication body text when you create an AWS Support case by calling <a>CreateCase</a>.
     */
    public String communicationBody() {
        return communicationBody;
    }

    /**
     * <p>
     * A list of email addresses that AWS Support copies on case correspondence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of email addresses that AWS Support copies on case correspondence.
     */
    public List<String> ccEmailAddresses() {
        return ccEmailAddresses;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en")
     * and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     * </p>
     * 
     * @return The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
     *         ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     */
    public String language() {
        return language;
    }

    /**
     * <p>
     * The type of issue for the case. You can specify either "customer-service" or "technical." If you do not indicate
     * a value, the default is "technical."
     * </p>
     * 
     * @return The type of issue for the case. You can specify either "customer-service" or "technical." If you do not
     *         indicate a value, the default is "technical."
     */
    public String issueType() {
        return issueType;
    }

    /**
     * <p>
     * The ID of a set of one or more attachments for the case. Create the set by using <a>AddAttachmentsToSet</a>.
     * </p>
     * 
     * @return The ID of a set of one or more attachments for the case. Create the set by using
     *         <a>AddAttachmentsToSet</a>.
     */
    public String attachmentSetId() {
        return attachmentSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((subject() == null) ? 0 : subject().hashCode());
        hashCode = 31 * hashCode + ((serviceCode() == null) ? 0 : serviceCode().hashCode());
        hashCode = 31 * hashCode + ((severityCode() == null) ? 0 : severityCode().hashCode());
        hashCode = 31 * hashCode + ((categoryCode() == null) ? 0 : categoryCode().hashCode());
        hashCode = 31 * hashCode + ((communicationBody() == null) ? 0 : communicationBody().hashCode());
        hashCode = 31 * hashCode + ((ccEmailAddresses() == null) ? 0 : ccEmailAddresses().hashCode());
        hashCode = 31 * hashCode + ((language() == null) ? 0 : language().hashCode());
        hashCode = 31 * hashCode + ((issueType() == null) ? 0 : issueType().hashCode());
        hashCode = 31 * hashCode + ((attachmentSetId() == null) ? 0 : attachmentSetId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCaseRequest)) {
            return false;
        }
        CreateCaseRequest other = (CreateCaseRequest) obj;
        if (other.subject() == null ^ this.subject() == null) {
            return false;
        }
        if (other.subject() != null && !other.subject().equals(this.subject())) {
            return false;
        }
        if (other.serviceCode() == null ^ this.serviceCode() == null) {
            return false;
        }
        if (other.serviceCode() != null && !other.serviceCode().equals(this.serviceCode())) {
            return false;
        }
        if (other.severityCode() == null ^ this.severityCode() == null) {
            return false;
        }
        if (other.severityCode() != null && !other.severityCode().equals(this.severityCode())) {
            return false;
        }
        if (other.categoryCode() == null ^ this.categoryCode() == null) {
            return false;
        }
        if (other.categoryCode() != null && !other.categoryCode().equals(this.categoryCode())) {
            return false;
        }
        if (other.communicationBody() == null ^ this.communicationBody() == null) {
            return false;
        }
        if (other.communicationBody() != null && !other.communicationBody().equals(this.communicationBody())) {
            return false;
        }
        if (other.ccEmailAddresses() == null ^ this.ccEmailAddresses() == null) {
            return false;
        }
        if (other.ccEmailAddresses() != null && !other.ccEmailAddresses().equals(this.ccEmailAddresses())) {
            return false;
        }
        if (other.language() == null ^ this.language() == null) {
            return false;
        }
        if (other.language() != null && !other.language().equals(this.language())) {
            return false;
        }
        if (other.issueType() == null ^ this.issueType() == null) {
            return false;
        }
        if (other.issueType() != null && !other.issueType().equals(this.issueType())) {
            return false;
        }
        if (other.attachmentSetId() == null ^ this.attachmentSetId() == null) {
            return false;
        }
        if (other.attachmentSetId() != null && !other.attachmentSetId().equals(this.attachmentSetId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (subject() != null) {
            sb.append("Subject: ").append(subject()).append(",");
        }
        if (serviceCode() != null) {
            sb.append("ServiceCode: ").append(serviceCode()).append(",");
        }
        if (severityCode() != null) {
            sb.append("SeverityCode: ").append(severityCode()).append(",");
        }
        if (categoryCode() != null) {
            sb.append("CategoryCode: ").append(categoryCode()).append(",");
        }
        if (communicationBody() != null) {
            sb.append("CommunicationBody: ").append(communicationBody()).append(",");
        }
        if (ccEmailAddresses() != null) {
            sb.append("CcEmailAddresses: ").append(ccEmailAddresses()).append(",");
        }
        if (language() != null) {
            sb.append("Language: ").append(language()).append(",");
        }
        if (issueType() != null) {
            sb.append("IssueType: ").append(issueType()).append(",");
        }
        if (attachmentSetId() != null) {
            sb.append("AttachmentSetId: ").append(attachmentSetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subject":
            return Optional.of(clazz.cast(subject()));
        case "serviceCode":
            return Optional.of(clazz.cast(serviceCode()));
        case "severityCode":
            return Optional.of(clazz.cast(severityCode()));
        case "categoryCode":
            return Optional.of(clazz.cast(categoryCode()));
        case "communicationBody":
            return Optional.of(clazz.cast(communicationBody()));
        case "ccEmailAddresses":
            return Optional.of(clazz.cast(ccEmailAddresses()));
        case "language":
            return Optional.of(clazz.cast(language()));
        case "issueType":
            return Optional.of(clazz.cast(issueType()));
        case "attachmentSetId":
            return Optional.of(clazz.cast(attachmentSetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateCaseRequest> {
        /**
         * <p>
         * The title of the AWS Support case.
         * </p>
         * 
         * @param subject
         *        The title of the AWS Support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The code for the AWS service returned by the call to <a>DescribeServices</a>.
         * </p>
         * 
         * @param serviceCode
         *        The code for the AWS service returned by the call to <a>DescribeServices</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
         * </p>
         * <note>
         * <p>
         * The availability of severity levels depends on each customer's support subscription. In other words, your
         * subscription may not necessarily require the urgent level of response time.
         * </p>
         * </note>
         * 
         * @param severityCode
         *        The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.</p> <note>
         *        <p>
         *        The availability of severity levels depends on each customer's support subscription. In other words,
         *        your subscription may not necessarily require the urgent level of response time.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCode(String severityCode);

        /**
         * <p>
         * The category of problem for the AWS Support case.
         * </p>
         * 
         * @param categoryCode
         *        The category of problem for the AWS Support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryCode(String categoryCode);

        /**
         * <p>
         * The communication body text when you create an AWS Support case by calling <a>CreateCase</a>.
         * </p>
         * 
         * @param communicationBody
         *        The communication body text when you create an AWS Support case by calling <a>CreateCase</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationBody(String communicationBody);

        /**
         * <p>
         * A list of email addresses that AWS Support copies on case correspondence.
         * </p>
         * 
         * @param ccEmailAddresses
         *        A list of email addresses that AWS Support copies on case correspondence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(Collection<String> ccEmailAddresses);

        /**
         * <p>
         * A list of email addresses that AWS Support copies on case correspondence.
         * </p>
         * 
         * @param ccEmailAddresses
         *        A list of email addresses that AWS Support copies on case correspondence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(String... ccEmailAddresses);

        /**
         * <p>
         * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
         * ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
         *        English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that
         *        take them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The type of issue for the case. You can specify either "customer-service" or "technical." If you do not
         * indicate a value, the default is "technical."
         * </p>
         * 
         * @param issueType
         *        The type of issue for the case. You can specify either "customer-service" or "technical." If you do
         *        not indicate a value, the default is "technical."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueType(String issueType);

        /**
         * <p>
         * The ID of a set of one or more attachments for the case. Create the set by using <a>AddAttachmentsToSet</a>.
         * </p>
         * 
         * @param attachmentSetId
         *        The ID of a set of one or more attachments for the case. Create the set by using
         *        <a>AddAttachmentsToSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSetId(String attachmentSetId);
    }

    static final class BuilderImpl implements Builder {
        private String subject;

        private String serviceCode;

        private String severityCode;

        private String categoryCode;

        private String communicationBody;

        private List<String> ccEmailAddresses;

        private String language;

        private String issueType;

        private String attachmentSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCaseRequest model) {
            subject(model.subject);
            serviceCode(model.serviceCode);
            severityCode(model.severityCode);
            categoryCode(model.categoryCode);
            communicationBody(model.communicationBody);
            ccEmailAddresses(model.ccEmailAddresses);
            language(model.language);
            issueType(model.issueType);
            attachmentSetId(model.attachmentSetId);
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getSeverityCode() {
            return severityCode;
        }

        @Override
        public final Builder severityCode(String severityCode) {
            this.severityCode = severityCode;
            return this;
        }

        public final void setSeverityCode(String severityCode) {
            this.severityCode = severityCode;
        }

        public final String getCategoryCode() {
            return categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        public final String getCommunicationBody() {
            return communicationBody;
        }

        @Override
        public final Builder communicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
            return this;
        }

        public final void setCommunicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
        }

        public final Collection<String> getCcEmailAddresses() {
            return ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String... ccEmailAddresses) {
            ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final String getIssueType() {
            return issueType;
        }

        @Override
        public final Builder issueType(String issueType) {
            this.issueType = issueType;
            return this;
        }

        public final void setIssueType(String issueType) {
            this.issueType = issueType;
        }

        public final String getAttachmentSetId() {
            return attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        @Override
        public CreateCaseRequest build() {
            return new CreateCaseRequest(this);
        }
    }
}
