/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summaries of the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorCheckSummaries</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTrustedAdvisorCheckSummariesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeTrustedAdvisorCheckSummariesResponse.Builder, DescribeTrustedAdvisorCheckSummariesResponse> {
    private final List<TrustedAdvisorCheckSummary> summaries;

    private DescribeTrustedAdvisorCheckSummariesResponse(BuilderImpl builder) {
        this.summaries = builder.summaries;
    }

    /**
     * <p>
     * The summary information for the requested Trusted Advisor checks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The summary information for the requested Trusted Advisor checks.
     */
    public List<TrustedAdvisorCheckSummary> summaries() {
        return summaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((summaries() == null) ? 0 : summaries().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckSummariesResponse)) {
            return false;
        }
        DescribeTrustedAdvisorCheckSummariesResponse other = (DescribeTrustedAdvisorCheckSummariesResponse) obj;
        if (other.summaries() == null ^ this.summaries() == null) {
            return false;
        }
        if (other.summaries() != null && !other.summaries().equals(this.summaries())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (summaries() != null) {
            sb.append("Summaries: ").append(summaries()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summaries":
            return Optional.of(clazz.cast(summaries()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTrustedAdvisorCheckSummariesResponse> {
        /**
         * <p>
         * The summary information for the requested Trusted Advisor checks.
         * </p>
         * 
         * @param summaries
         *        The summary information for the requested Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<TrustedAdvisorCheckSummary> summaries);

        /**
         * <p>
         * The summary information for the requested Trusted Advisor checks.
         * </p>
         * 
         * @param summaries
         *        The summary information for the requested Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(TrustedAdvisorCheckSummary... summaries);
    }

    static final class BuilderImpl implements Builder {
        private List<TrustedAdvisorCheckSummary> summaries;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckSummariesResponse model) {
            summaries(model.summaries);
        }

        public final Collection<TrustedAdvisorCheckSummary.Builder> getSummaries() {
            return summaries != null ? summaries.stream().map(TrustedAdvisorCheckSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder summaries(Collection<TrustedAdvisorCheckSummary> summaries) {
            this.summaries = TrustedAdvisorCheckSummaryListCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(TrustedAdvisorCheckSummary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        public final void setSummaries(Collection<TrustedAdvisorCheckSummary.BuilderImpl> summaries) {
            this.summaries = TrustedAdvisorCheckSummaryListCopier.copyFromBuilder(summaries);
        }

        @Override
        public DescribeTrustedAdvisorCheckSummariesResponse build() {
            return new DescribeTrustedAdvisorCheckSummariesResponse(this);
        }
    }
}
