/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorChecks</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTrustedAdvisorChecksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeTrustedAdvisorChecksResponse.Builder, DescribeTrustedAdvisorChecksResponse> {
    private final List<TrustedAdvisorCheckDescription> checks;

    private DescribeTrustedAdvisorChecksResponse(BuilderImpl builder) {
        this.checks = builder.checks;
    }

    /**
     * <p>
     * Information about all available Trusted Advisor checks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about all available Trusted Advisor checks.
     */
    public List<TrustedAdvisorCheckDescription> checks() {
        return checks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((checks() == null) ? 0 : checks().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorChecksResponse)) {
            return false;
        }
        DescribeTrustedAdvisorChecksResponse other = (DescribeTrustedAdvisorChecksResponse) obj;
        if (other.checks() == null ^ this.checks() == null) {
            return false;
        }
        if (other.checks() != null && !other.checks().equals(this.checks())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (checks() != null) {
            sb.append("Checks: ").append(checks()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checks":
            return Optional.of(clazz.cast(checks()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTrustedAdvisorChecksResponse> {
        /**
         * <p>
         * Information about all available Trusted Advisor checks.
         * </p>
         * 
         * @param checks
         *        Information about all available Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checks(Collection<TrustedAdvisorCheckDescription> checks);

        /**
         * <p>
         * Information about all available Trusted Advisor checks.
         * </p>
         * 
         * @param checks
         *        Information about all available Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checks(TrustedAdvisorCheckDescription... checks);
    }

    static final class BuilderImpl implements Builder {
        private List<TrustedAdvisorCheckDescription> checks;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorChecksResponse model) {
            checks(model.checks);
        }

        public final Collection<TrustedAdvisorCheckDescription.Builder> getChecks() {
            return checks != null ? checks.stream().map(TrustedAdvisorCheckDescription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder checks(Collection<TrustedAdvisorCheckDescription> checks) {
            this.checks = TrustedAdvisorCheckListCopier.copy(checks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checks(TrustedAdvisorCheckDescription... checks) {
            checks(Arrays.asList(checks));
            return this;
        }

        public final void setChecks(Collection<TrustedAdvisorCheckDescription.BuilderImpl> checks) {
            this.checks = TrustedAdvisorCheckListCopier.copyFromBuilder(checks);
        }

        @Override
        public DescribeTrustedAdvisorChecksResponse build() {
            return new DescribeTrustedAdvisorChecksResponse(this);
        }
    }
}
