/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCategorySpecificSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for summary information that relates to the category of the Trusted Advisor check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrustedAdvisorCategorySpecificSummary implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorCategorySpecificSummary.Builder, TrustedAdvisorCategorySpecificSummary> {
    private final TrustedAdvisorCostOptimizingSummary costOptimizing;

    private TrustedAdvisorCategorySpecificSummary(BuilderImpl builder) {
        this.costOptimizing = builder.costOptimizing;
    }

    /**
     * <p>
     * The summary information about cost savings for a Trusted Advisor check that is in the Cost Optimizing category.
     * </p>
     * 
     * @return The summary information about cost savings for a Trusted Advisor check that is in the Cost Optimizing
     *         category.
     */
    public TrustedAdvisorCostOptimizingSummary costOptimizing() {
        return costOptimizing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((costOptimizing() == null) ? 0 : costOptimizing().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCategorySpecificSummary)) {
            return false;
        }
        TrustedAdvisorCategorySpecificSummary other = (TrustedAdvisorCategorySpecificSummary) obj;
        if (other.costOptimizing() == null ^ this.costOptimizing() == null) {
            return false;
        }
        if (other.costOptimizing() != null && !other.costOptimizing().equals(this.costOptimizing())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (costOptimizing() != null) {
            sb.append("CostOptimizing: ").append(costOptimizing()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "costOptimizing":
            return Optional.of(clazz.cast(costOptimizing()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCategorySpecificSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorCategorySpecificSummary> {
        /**
         * <p>
         * The summary information about cost savings for a Trusted Advisor check that is in the Cost Optimizing
         * category.
         * </p>
         * 
         * @param costOptimizing
         *        The summary information about cost savings for a Trusted Advisor check that is in the Cost Optimizing
         *        category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costOptimizing(TrustedAdvisorCostOptimizingSummary costOptimizing);
    }

    static final class BuilderImpl implements Builder {
        private TrustedAdvisorCostOptimizingSummary costOptimizing;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCategorySpecificSummary model) {
            costOptimizing(model.costOptimizing);
        }

        public final TrustedAdvisorCostOptimizingSummary.Builder getCostOptimizing() {
            return costOptimizing != null ? costOptimizing.toBuilder() : null;
        }

        @Override
        public final Builder costOptimizing(TrustedAdvisorCostOptimizingSummary costOptimizing) {
            this.costOptimizing = costOptimizing;
            return this;
        }

        public final void setCostOptimizing(TrustedAdvisorCostOptimizingSummary.BuilderImpl costOptimizing) {
            this.costOptimizing = costOptimizing != null ? costOptimizing.build() : null;
        }

        @Override
        public TrustedAdvisorCategorySpecificSummary build() {
            return new TrustedAdvisorCategorySpecificSummary(this);
        }
    }
}
