/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckResultMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The results of a Trusted Advisor check returned by <a>DescribeTrustedAdvisorCheckResult</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrustedAdvisorCheckResult implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorCheckResult.Builder, TrustedAdvisorCheckResult> {
    private final String checkId;

    private final String timestamp;

    private final String status;

    private final TrustedAdvisorResourcesSummary resourcesSummary;

    private final TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

    private final List<TrustedAdvisorResourceDetail> flaggedResources;

    private TrustedAdvisorCheckResult(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
        this.resourcesSummary = builder.resourcesSummary;
        this.categorySpecificSummary = builder.categorySpecificSummary;
        this.flaggedResources = builder.flaggedResources;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The time of the last refresh of the check.
     * </p>
     * 
     * @return The time of the last refresh of the check.
     */
    public String timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     * </p>
     * 
     * @return The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     */
    public String status() {
        return status;
    }

    /**
     * Returns the value of the ResourcesSummary property for this object.
     * 
     * @return The value of the ResourcesSummary property for this object.
     */
    public TrustedAdvisorResourcesSummary resourcesSummary() {
        return resourcesSummary;
    }

    /**
     * <p>
     * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
     * currently supported.
     * </p>
     * 
     * @return Summary information that relates to the category of the check. Cost Optimizing is the only category that
     *         is currently supported.
     */
    public TrustedAdvisorCategorySpecificSummary categorySpecificSummary() {
        return categorySpecificSummary;
    }

    /**
     * <p>
     * The details about each resource listed in the check result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The details about each resource listed in the check result.
     */
    public List<TrustedAdvisorResourceDetail> flaggedResources() {
        return flaggedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((checkId() == null) ? 0 : checkId().hashCode());
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((resourcesSummary() == null) ? 0 : resourcesSummary().hashCode());
        hashCode = 31 * hashCode + ((categorySpecificSummary() == null) ? 0 : categorySpecificSummary().hashCode());
        hashCode = 31 * hashCode + ((flaggedResources() == null) ? 0 : flaggedResources().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckResult)) {
            return false;
        }
        TrustedAdvisorCheckResult other = (TrustedAdvisorCheckResult) obj;
        if (other.checkId() == null ^ this.checkId() == null) {
            return false;
        }
        if (other.checkId() != null && !other.checkId().equals(this.checkId())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.resourcesSummary() == null ^ this.resourcesSummary() == null) {
            return false;
        }
        if (other.resourcesSummary() != null && !other.resourcesSummary().equals(this.resourcesSummary())) {
            return false;
        }
        if (other.categorySpecificSummary() == null ^ this.categorySpecificSummary() == null) {
            return false;
        }
        if (other.categorySpecificSummary() != null && !other.categorySpecificSummary().equals(this.categorySpecificSummary())) {
            return false;
        }
        if (other.flaggedResources() == null ^ this.flaggedResources() == null) {
            return false;
        }
        if (other.flaggedResources() != null && !other.flaggedResources().equals(this.flaggedResources())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (checkId() != null) {
            sb.append("CheckId: ").append(checkId()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (resourcesSummary() != null) {
            sb.append("ResourcesSummary: ").append(resourcesSummary()).append(",");
        }
        if (categorySpecificSummary() != null) {
            sb.append("CategorySpecificSummary: ").append(categorySpecificSummary()).append(",");
        }
        if (flaggedResources() != null) {
            sb.append("FlaggedResources: ").append(flaggedResources()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkId":
            return Optional.of(clazz.cast(checkId()));
        case "timestamp":
            return Optional.of(clazz.cast(timestamp()));
        case "status":
            return Optional.of(clazz.cast(status()));
        case "resourcesSummary":
            return Optional.of(clazz.cast(resourcesSummary()));
        case "categorySpecificSummary":
            return Optional.of(clazz.cast(categorySpecificSummary()));
        case "flaggedResources":
            return Optional.of(clazz.cast(flaggedResources()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorCheckResult> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The time of the last refresh of the check.
         * </p>
         * 
         * @param timestamp
         *        The time of the last refresh of the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);

        /**
         * <p>
         * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         * </p>
         * 
         * @param status
         *        The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * Sets the value of the ResourcesSummary property for this object.
         *
         * @param resourcesSummary
         *        The new value for the ResourcesSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary);

        /**
         * <p>
         * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
         * currently supported.
         * </p>
         * 
         * @param categorySpecificSummary
         *        Summary information that relates to the category of the check. Cost Optimizing is the only category
         *        that is currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary);

        /**
         * <p>
         * The details about each resource listed in the check result.
         * </p>
         * 
         * @param flaggedResources
         *        The details about each resource listed in the check result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flaggedResources(Collection<TrustedAdvisorResourceDetail> flaggedResources);

        /**
         * <p>
         * The details about each resource listed in the check result.
         * </p>
         * 
         * @param flaggedResources
         *        The details about each resource listed in the check result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flaggedResources(TrustedAdvisorResourceDetail... flaggedResources);
    }

    static final class BuilderImpl implements Builder {
        private String checkId;

        private String timestamp;

        private String status;

        private TrustedAdvisorResourcesSummary resourcesSummary;

        private TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

        private List<TrustedAdvisorResourceDetail> flaggedResources;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckResult model) {
            checkId(model.checkId);
            timestamp(model.timestamp);
            status(model.status);
            resourcesSummary(model.resourcesSummary);
            categorySpecificSummary(model.categorySpecificSummary);
            flaggedResources(model.flaggedResources);
        }

        public final String getCheckId() {
            return checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final TrustedAdvisorResourcesSummary.Builder getResourcesSummary() {
            return resourcesSummary != null ? resourcesSummary.toBuilder() : null;
        }

        @Override
        public final Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary) {
            this.resourcesSummary = resourcesSummary;
            return this;
        }

        public final void setResourcesSummary(TrustedAdvisorResourcesSummary.BuilderImpl resourcesSummary) {
            this.resourcesSummary = resourcesSummary != null ? resourcesSummary.build() : null;
        }

        public final TrustedAdvisorCategorySpecificSummary.Builder getCategorySpecificSummary() {
            return categorySpecificSummary != null ? categorySpecificSummary.toBuilder() : null;
        }

        @Override
        public final Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary;
            return this;
        }

        public final void setCategorySpecificSummary(TrustedAdvisorCategorySpecificSummary.BuilderImpl categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary != null ? categorySpecificSummary.build() : null;
        }

        public final Collection<TrustedAdvisorResourceDetail.Builder> getFlaggedResources() {
            return flaggedResources != null ? flaggedResources.stream().map(TrustedAdvisorResourceDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder flaggedResources(Collection<TrustedAdvisorResourceDetail> flaggedResources) {
            this.flaggedResources = TrustedAdvisorResourceDetailListCopier.copy(flaggedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flaggedResources(TrustedAdvisorResourceDetail... flaggedResources) {
            flaggedResources(Arrays.asList(flaggedResources));
            return this;
        }

        public final void setFlaggedResources(Collection<TrustedAdvisorResourceDetail.BuilderImpl> flaggedResources) {
            this.flaggedResources = TrustedAdvisorResourceDetailListCopier.copyFromBuilder(flaggedResources);
        }

        @Override
        public TrustedAdvisorCheckResult build() {
            return new TrustedAdvisorCheckResult(this);
        }
    }
}
