/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.StringListCopier;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorResourceDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TrustedAdvisorResourceDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, TrustedAdvisorResourceDetail> {
    private final String status;
    private final String region;
    private final String resourceId;
    private final Boolean isSuppressed;
    private final List<String> metadata;

    private TrustedAdvisorResourceDetail(BuilderImpl builder) {
        this.status = builder.status;
        this.region = builder.region;
        this.resourceId = builder.resourceId;
        this.isSuppressed = builder.isSuppressed;
        this.metadata = builder.metadata;
    }

    public String status() {
        return this.status;
    }

    public String region() {
        return this.region;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Boolean isSuppressed() {
        return this.isSuppressed;
    }

    public List<String> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.region() == null ? 0 : this.region().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.isSuppressed() == null ? 0 : this.isSuppressed().hashCode());
        hashCode = 31 * hashCode + (this.metadata() == null ? 0 : this.metadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorResourceDetail)) {
            return false;
        }
        TrustedAdvisorResourceDetail other = (TrustedAdvisorResourceDetail)obj;
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.isSuppressed() == null ^ this.isSuppressed() == null) {
            return false;
        }
        if (other.isSuppressed() != null && !other.isSuppressed().equals(this.isSuppressed())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        return other.metadata() == null || other.metadata().equals(this.metadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.isSuppressed() != null) {
            sb.append("IsSuppressed: ").append(this.isSuppressed()).append(",");
        }
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "resourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "isSuppressed": {
                return Optional.of(clazz.cast(this.isSuppressed()));
            }
            case "metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorResourceDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String region;
        private String resourceId;
        private Boolean isSuppressed;
        private List<String> metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorResourceDetail model) {
            this.status(model.status);
            this.region(model.region);
            this.resourceId(model.resourceId);
            this.isSuppressed(model.isSuppressed);
            this.metadata(model.metadata);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Boolean getIsSuppressed() {
            return this.isSuppressed;
        }

        @Override
        public final Builder isSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
            return this;
        }

        public final void setIsSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
        }

        public final Collection<String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(String ... metadata) {
            this.metadata(Arrays.asList(metadata));
            return this;
        }

        public final void setMetadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
        }

        public TrustedAdvisorResourceDetail build() {
            return new TrustedAdvisorResourceDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrustedAdvisorResourceDetail> {
        public Builder status(String var1);

        public Builder region(String var1);

        public Builder resourceId(String var1);

        public Builder isSuppressed(Boolean var1);

        public Builder metadata(Collection<String> var1);

        public Builder metadata(String ... var1);
    }
}

