/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddAttachmentsToSetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AddAttachmentsToSetRequest.Builder, AddAttachmentsToSetRequest> {
    private final String attachmentSetId;

    private final List<Attachment> attachments;

    private AddAttachmentsToSetRequest(BuilderImpl builder) {
        this.attachmentSetId = builder.attachmentSetId;
        this.attachments = builder.attachments;
    }

    /**
     * <p>
     * The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is
     * created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified, the
     * attachments are added to the specified set, if it exists.
     * </p>
     * 
     * @return The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set
     *         is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is
     *         specified, the attachments are added to the specified set, if it exists.
     */
    public String attachmentSetId() {
        return attachmentSetId;
    }

    /**
     * <p>
     * One or more attachments to add to the set. The limit is 3 attachments per set, and the size limit is 5 MB per
     * attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more attachments to add to the set. The limit is 3 attachments per set, and the size limit is 5 MB
     *         per attachment.
     */
    public List<Attachment> attachments() {
        return attachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentSetId());
        hashCode = 31 * hashCode + Objects.hashCode(attachments());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAttachmentsToSetRequest)) {
            return false;
        }
        AddAttachmentsToSetRequest other = (AddAttachmentsToSetRequest) obj;
        return Objects.equals(attachmentSetId(), other.attachmentSetId()) && Objects.equals(attachments(), other.attachments());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attachmentSetId() != null) {
            sb.append("AttachmentSetId: ").append(attachmentSetId()).append(",");
        }
        if (attachments() != null) {
            sb.append("Attachments: ").append(attachments()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentSetId":
            return Optional.of(clazz.cast(attachmentSetId()));
        case "attachments":
            return Optional.of(clazz.cast(attachments()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AddAttachmentsToSetRequest> {
        /**
         * <p>
         * The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is
         * created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified,
         * the attachments are added to the specified set, if it exists.
         * </p>
         * 
         * @param attachmentSetId
         *        The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment
         *        set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code>
         *        is specified, the attachments are added to the specified set, if it exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSetId(String attachmentSetId);

        /**
         * <p>
         * One or more attachments to add to the set. The limit is 3 attachments per set, and the size limit is 5 MB per
         * attachment.
         * </p>
         * 
         * @param attachments
         *        One or more attachments to add to the set. The limit is 3 attachments per set, and the size limit is 5
         *        MB per attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<Attachment> attachments);

        /**
         * <p>
         * One or more attachments to add to the set. The limit is 3 attachments per set, and the size limit is 5 MB per
         * attachment.
         * </p>
         * 
         * @param attachments
         *        One or more attachments to add to the set. The limit is 3 attachments per set, and the size limit is 5
         *        MB per attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Attachment... attachments);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentSetId;

        private List<Attachment> attachments;

        private BuilderImpl() {
        }

        private BuilderImpl(AddAttachmentsToSetRequest model) {
            attachmentSetId(model.attachmentSetId);
            attachments(model.attachments);
        }

        public final String getAttachmentSetId() {
            return attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        public final Collection<Attachment.Builder> getAttachments() {
            return attachments != null ? attachments.stream().map(Attachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Attachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        public final void setAttachments(Collection<Attachment.BuilderImpl> attachments) {
            this.attachments = AttachmentsCopier.copyFromBuilder(attachments);
        }

        @Override
        public AddAttachmentsToSetRequest build() {
            return new AddAttachmentsToSetRequest(this);
        }
    }
}
